/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.x500.style;

import java.io.IOException;
import java.util.Hashtable;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.DERIA5String;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DERPrintableString;
import kz.gamma.asn1.DERUTF8String;
import kz.gamma.asn1.x500.AttributeTypeAndValue;
import kz.gamma.asn1.x500.RDN;
import kz.gamma.asn1.x500.X500Name;
import kz.gamma.asn1.x500.X500NameStyle;
import kz.gamma.asn1.x500.style.IETFUtils;

public class RFC4519Style
implements X500NameStyle {
    public static final X500NameStyle INSTANCE = new RFC4519Style();
    public static final DERObjectIdentifier businessCategory = new DERObjectIdentifier("2.5.4.15");
    public static final DERObjectIdentifier c = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier cn = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier dc = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
    public static final DERObjectIdentifier description = new DERObjectIdentifier("2.5.4.13");
    public static final DERObjectIdentifier destinationIndicator = new DERObjectIdentifier("2.5.4.27");
    public static final DERObjectIdentifier distinguishedName = new DERObjectIdentifier("2.5.4.49");
    public static final DERObjectIdentifier dnQualifier = new DERObjectIdentifier("2.5.4.46");
    public static final DERObjectIdentifier enhancedSearchGuide = new DERObjectIdentifier("2.5.4.47");
    public static final DERObjectIdentifier facsimileTelephoneNumber = new DERObjectIdentifier("2.5.4.23");
    public static final DERObjectIdentifier generationQualifier = new DERObjectIdentifier("2.5.4.44");
    public static final DERObjectIdentifier givenName = new DERObjectIdentifier("2.5.4.42");
    public static final DERObjectIdentifier houseIdentifier = new DERObjectIdentifier("2.5.4.51");
    public static final DERObjectIdentifier initials = new DERObjectIdentifier("2.5.4.43");
    public static final DERObjectIdentifier internationalISDNNumber = new DERObjectIdentifier("2.5.4.25");
    public static final DERObjectIdentifier l = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier member = new DERObjectIdentifier("2.5.4.31");
    public static final DERObjectIdentifier name = new DERObjectIdentifier("2.5.4.41");
    public static final DERObjectIdentifier o = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier ou = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier owner = new DERObjectIdentifier("2.5.4.32");
    public static final DERObjectIdentifier physicalDeliveryOfficeName = new DERObjectIdentifier("2.5.4.19");
    public static final DERObjectIdentifier postalAddress = new DERObjectIdentifier("2.5.4.16");
    public static final DERObjectIdentifier postalCode = new DERObjectIdentifier("2.5.4.17");
    public static final DERObjectIdentifier postOfficeBox = new DERObjectIdentifier("2.5.4.18");
    public static final DERObjectIdentifier preferredDeliveryMethod = new DERObjectIdentifier("2.5.4.28");
    public static final DERObjectIdentifier registeredAddress = new DERObjectIdentifier("2.5.4.26");
    public static final DERObjectIdentifier roleOccupant = new DERObjectIdentifier("2.5.4.33");
    public static final DERObjectIdentifier searchGuide = new DERObjectIdentifier("2.5.4.14");
    public static final DERObjectIdentifier seeAlso = new DERObjectIdentifier("2.5.4.34");
    public static final DERObjectIdentifier serialNumber = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier sn = new DERObjectIdentifier("2.5.4.4");
    public static final DERObjectIdentifier st = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier street = new DERObjectIdentifier("2.5.4.9");
    public static final DERObjectIdentifier telephoneNumber = new DERObjectIdentifier("2.5.4.20");
    public static final DERObjectIdentifier teletexTerminalIdentifier = new DERObjectIdentifier("2.5.4.22");
    public static final DERObjectIdentifier telexNumber = new DERObjectIdentifier("2.5.4.21");
    public static final DERObjectIdentifier title = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier uid = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
    public static final DERObjectIdentifier uniqueMember = new DERObjectIdentifier("2.5.4.50");
    public static final DERObjectIdentifier userPassword = new DERObjectIdentifier("2.5.4.35");
    public static final DERObjectIdentifier x121Address = new DERObjectIdentifier("2.5.4.24");
    public static final DERObjectIdentifier x500UniqueIdentifier = new DERObjectIdentifier("2.5.4.45");
    private static final Hashtable DefaultSymbols = new Hashtable();
    private static final Hashtable DefaultLookUp = new Hashtable();

    protected RFC4519Style() {
    }

    @Override
    public ASN1Encodable stringToValue(DERObjectIdentifier oid, String value) {
        if (value.length() != 0 && value.charAt(0) == '#') {
            try {
                return IETFUtils.valueFromHexString(value, 1);
            }
            catch (IOException e) {
                throw new RuntimeException("can't recode value for oid " + oid.getId());
            }
        }
        if (value.length() != 0 && value.charAt(0) == '\\') {
            value = value.substring(1);
        }
        if (oid.equals(dc)) {
            return new DERIA5String(value);
        }
        if (oid.equals(c) || oid.equals(serialNumber) || oid.equals(dnQualifier) || oid.equals(telephoneNumber)) {
            return new DERPrintableString(value);
        }
        return new DERUTF8String(value);
    }

    @Override
    public String oidToDisplayName(DERObjectIdentifier oid) {
        return (String)DefaultSymbols.get(oid);
    }

    @Override
    public String[] oidToAttrNames(DERObjectIdentifier oid) {
        return IETFUtils.findAttrNamesForOID(oid, DefaultLookUp);
    }

    @Override
    public DERObjectIdentifier attrNameToOID(String attrName) {
        return IETFUtils.decodeAttrName(attrName, DefaultLookUp);
    }

    @Override
    public boolean areEqual(X500Name name1, X500Name name2) {
        RDN[] rdns2;
        RDN[] rdns1 = name1.getRDNs();
        if (rdns1.length != (rdns2 = name2.getRDNs()).length) {
            return false;
        }
        boolean reverse = false;
        if (rdns1[0].getFirst() != null && rdns2[0].getFirst() != null) {
            reverse = !rdns1[0].getFirst().getType().equals(rdns2[0].getFirst().getType());
        }
        for (int i = 0; i != rdns1.length; ++i) {
            if (this.foundMatch(reverse, rdns1[i], rdns2)) continue;
            return false;
        }
        return true;
    }

    private boolean foundMatch(boolean reverse, RDN rdn, RDN[] possRDNs) {
        if (reverse) {
            for (int i = possRDNs.length - 1; i >= 0; --i) {
                if (possRDNs[i] == null || !this.rdnAreEqual(rdn, possRDNs[i])) continue;
                possRDNs[i] = null;
                return true;
            }
        } else {
            for (int i = 0; i != possRDNs.length; ++i) {
                if (possRDNs[i] == null || !this.rdnAreEqual(rdn, possRDNs[i])) continue;
                possRDNs[i] = null;
                return true;
            }
        }
        return false;
    }

    protected boolean rdnAreEqual(RDN rdn1, RDN rdn2) {
        return IETFUtils.rDNAreEqual(rdn1, rdn2);
    }

    @Override
    public RDN[] fromString(String dirName) {
        RDN[] tmp = IETFUtils.rDNsFromString(dirName, this);
        RDN[] res = new RDN[tmp.length];
        for (int i = 0; i != tmp.length; ++i) {
            res[res.length - i - 1] = tmp[i];
        }
        return res;
    }

    @Override
    public int calculateHashCode(X500Name name) {
        int hashCodeValue = 0;
        RDN[] rdns = name.getRDNs();
        for (int i = 0; i != rdns.length; ++i) {
            if (rdns[i].isMultiValued()) {
                AttributeTypeAndValue[] atv = rdns[i].getTypesAndValues();
                for (int j = 0; j != atv.length; ++j) {
                    hashCodeValue ^= atv[j].getType().hashCode();
                    hashCodeValue ^= this.calcHashCode(atv[j].getValue());
                }
                continue;
            }
            hashCodeValue ^= rdns[i].getFirst().getType().hashCode();
            hashCodeValue ^= this.calcHashCode(rdns[i].getFirst().getValue());
        }
        return hashCodeValue;
    }

    private int calcHashCode(ASN1Encodable enc) {
        String value = IETFUtils.valueToString(enc);
        value = IETFUtils.canonicalize(value);
        return value.hashCode();
    }

    @Override
    public String toString(X500Name name) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        RDN[] rdns = name.getRDNs();
        for (int i = rdns.length - 1; i >= 0; --i) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            IETFUtils.appendRDN(buf, rdns[i], DefaultSymbols);
        }
        return buf.toString();
    }

    static {
        DefaultSymbols.put(businessCategory, "businessCategory");
        DefaultSymbols.put(c, "c");
        DefaultSymbols.put(cn, "cn");
        DefaultSymbols.put(dc, "dc");
        DefaultSymbols.put(description, "description");
        DefaultSymbols.put(destinationIndicator, "destinationIndicator");
        DefaultSymbols.put(distinguishedName, "distinguishedName");
        DefaultSymbols.put(dnQualifier, "dnQualifier");
        DefaultSymbols.put(enhancedSearchGuide, "enhancedSearchGuide");
        DefaultSymbols.put(facsimileTelephoneNumber, "facsimileTelephoneNumber");
        DefaultSymbols.put(generationQualifier, "generationQualifier");
        DefaultSymbols.put(givenName, "givenName");
        DefaultSymbols.put(houseIdentifier, "houseIdentifier");
        DefaultSymbols.put(initials, "initials");
        DefaultSymbols.put(internationalISDNNumber, "internationalISDNNumber");
        DefaultSymbols.put(l, "l");
        DefaultSymbols.put(member, "member");
        DefaultSymbols.put(name, "name");
        DefaultSymbols.put(o, "o");
        DefaultSymbols.put(ou, "ou");
        DefaultSymbols.put(owner, "owner");
        DefaultSymbols.put(physicalDeliveryOfficeName, "physicalDeliveryOfficeName");
        DefaultSymbols.put(postalAddress, "postalAddress");
        DefaultSymbols.put(postalCode, "postalCode");
        DefaultSymbols.put(postOfficeBox, "postOfficeBox");
        DefaultSymbols.put(preferredDeliveryMethod, "preferredDeliveryMethod");
        DefaultSymbols.put(registeredAddress, "registeredAddress");
        DefaultSymbols.put(roleOccupant, "roleOccupant");
        DefaultSymbols.put(searchGuide, "searchGuide");
        DefaultSymbols.put(seeAlso, "seeAlso");
        DefaultSymbols.put(serialNumber, "serialNumber");
        DefaultSymbols.put(sn, "sn");
        DefaultSymbols.put(st, "st");
        DefaultSymbols.put(street, "street");
        DefaultSymbols.put(telephoneNumber, "telephoneNumber");
        DefaultSymbols.put(teletexTerminalIdentifier, "teletexTerminalIdentifier");
        DefaultSymbols.put(telexNumber, "telexNumber");
        DefaultSymbols.put(title, "title");
        DefaultSymbols.put(uid, "uid");
        DefaultSymbols.put(uniqueMember, "uniqueMember");
        DefaultSymbols.put(userPassword, "userPassword");
        DefaultSymbols.put(x121Address, "x121Address");
        DefaultSymbols.put(x500UniqueIdentifier, "x500UniqueIdentifier");
        DefaultLookUp.put("businesscategory", businessCategory);
        DefaultLookUp.put("c", c);
        DefaultLookUp.put("cn", cn);
        DefaultLookUp.put("dc", dc);
        DefaultLookUp.put("description", description);
        DefaultLookUp.put("destinationindicator", destinationIndicator);
        DefaultLookUp.put("distinguishedname", distinguishedName);
        DefaultLookUp.put("dnqualifier", dnQualifier);
        DefaultLookUp.put("enhancedsearchguide", enhancedSearchGuide);
        DefaultLookUp.put("facsimiletelephonenumber", facsimileTelephoneNumber);
        DefaultLookUp.put("generationqualifier", generationQualifier);
        DefaultLookUp.put("givenname", givenName);
        DefaultLookUp.put("houseidentifier", houseIdentifier);
        DefaultLookUp.put("initials", initials);
        DefaultLookUp.put("internationalisdnnumber", internationalISDNNumber);
        DefaultLookUp.put("l", l);
        DefaultLookUp.put("member", member);
        DefaultLookUp.put("name", name);
        DefaultLookUp.put("o", o);
        DefaultLookUp.put("ou", ou);
        DefaultLookUp.put("owner", owner);
        DefaultLookUp.put("physicaldeliveryofficename", physicalDeliveryOfficeName);
        DefaultLookUp.put("postaladdress", postalAddress);
        DefaultLookUp.put("postalcode", postalCode);
        DefaultLookUp.put("postofficebox", postOfficeBox);
        DefaultLookUp.put("preferreddeliverymethod", preferredDeliveryMethod);
        DefaultLookUp.put("registeredaddress", registeredAddress);
        DefaultLookUp.put("roleoccupant", roleOccupant);
        DefaultLookUp.put("searchguide", searchGuide);
        DefaultLookUp.put("seealso", seeAlso);
        DefaultLookUp.put("serialnumber", serialNumber);
        DefaultLookUp.put("sn", sn);
        DefaultLookUp.put("st", st);
        DefaultLookUp.put("street", street);
        DefaultLookUp.put("telephonenumber", telephoneNumber);
        DefaultLookUp.put("teletexterminalidentifier", teletexTerminalIdentifier);
        DefaultLookUp.put("telexnumber", telexNumber);
        DefaultLookUp.put("title", title);
        DefaultLookUp.put("uid", uid);
        DefaultLookUp.put("uniquemember", uniqueMember);
        DefaultLookUp.put("userpassword", userPassword);
        DefaultLookUp.put("x121address", x121Address);
        DefaultLookUp.put("x500uniqueidentifier", x500UniqueIdentifier);
    }
}

