/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.x509;

import java.io.IOException;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Object;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DERBoolean;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;

public class Extension
extends ASN1Encodable {
    public static final DERObjectIdentifier subjectDirectoryAttributes = new DERObjectIdentifier("2.5.29.9");
    public static final DERObjectIdentifier subjectKeyIdentifier = new DERObjectIdentifier("2.5.29.14");
    public static final DERObjectIdentifier keyUsage = new DERObjectIdentifier("2.5.29.15");
    public static final DERObjectIdentifier privateKeyUsagePeriod = new DERObjectIdentifier("2.5.29.16");
    public static final DERObjectIdentifier subjectAlternativeName = new DERObjectIdentifier("2.5.29.17");
    public static final DERObjectIdentifier issuerAlternativeName = new DERObjectIdentifier("2.5.29.18");
    public static final DERObjectIdentifier basicConstraints = new DERObjectIdentifier("2.5.29.19");
    public static final DERObjectIdentifier cRLNumber = new DERObjectIdentifier("2.5.29.20");
    public static final DERObjectIdentifier reasonCode = new DERObjectIdentifier("2.5.29.21");
    public static final DERObjectIdentifier instructionCode = new DERObjectIdentifier("2.5.29.23");
    public static final DERObjectIdentifier invalidityDate = new DERObjectIdentifier("2.5.29.24");
    public static final DERObjectIdentifier deltaCRLIndicator = new DERObjectIdentifier("2.5.29.27");
    public static final DERObjectIdentifier issuingDistributionPoint = new DERObjectIdentifier("2.5.29.28");
    public static final DERObjectIdentifier certificateIssuer = new DERObjectIdentifier("2.5.29.29");
    public static final DERObjectIdentifier nameConstraints = new DERObjectIdentifier("2.5.29.30");
    public static final DERObjectIdentifier cRLDistributionPoints = new DERObjectIdentifier("2.5.29.31");
    public static final DERObjectIdentifier certificatePolicies = new DERObjectIdentifier("2.5.29.32");
    public static final DERObjectIdentifier policyMappings = new DERObjectIdentifier("2.5.29.33");
    public static final DERObjectIdentifier authorityKeyIdentifier = new DERObjectIdentifier("2.5.29.35");
    public static final DERObjectIdentifier policyConstraints = new DERObjectIdentifier("2.5.29.36");
    public static final DERObjectIdentifier extendedKeyUsage = new DERObjectIdentifier("2.5.29.37");
    public static final DERObjectIdentifier freshestCRL = new DERObjectIdentifier("2.5.29.46");
    public static final DERObjectIdentifier inhibitAnyPolicy = new DERObjectIdentifier("2.5.29.54");
    public static final DERObjectIdentifier authorityInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.1");
    public static final DERObjectIdentifier subjectInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.11");
    public static final DERObjectIdentifier logoType = new DERObjectIdentifier("1.3.6.1.5.5.7.1.12");
    public static final DERObjectIdentifier biometricInfo = new DERObjectIdentifier("1.3.6.1.5.5.7.1.2");
    public static final DERObjectIdentifier qCStatements = new DERObjectIdentifier("1.3.6.1.5.5.7.1.3");
    public static final DERObjectIdentifier auditIdentity = new DERObjectIdentifier("1.3.6.1.5.5.7.1.4");
    public static final DERObjectIdentifier noRevAvail = new DERObjectIdentifier("2.5.29.56");
    public static final DERObjectIdentifier targetInformation = new DERObjectIdentifier("2.5.29.55");
    private DERObjectIdentifier extnId;
    private boolean critical;
    private ASN1OctetString value;

    public Extension(DERObjectIdentifier extnId, DERBoolean critical, ASN1OctetString value) {
        this(extnId, critical.isTrue(), value);
    }

    public Extension(DERObjectIdentifier extnId, boolean critical, byte[] value) {
        this(extnId, critical, (ASN1OctetString)new DEROctetString(value));
    }

    public Extension(DERObjectIdentifier extnId, boolean critical, ASN1OctetString value) {
        this.extnId = extnId;
        this.critical = critical;
        this.value = value;
    }

    private Extension(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.extnId = DERObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.critical = false;
            this.value = ASN1OctetString.getInstance(seq.getObjectAt(1));
        } else if (seq.size() == 3) {
            this.extnId = DERObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.critical = DERBoolean.getInstance(seq.getObjectAt(1)).isTrue();
            this.value = ASN1OctetString.getInstance(seq.getObjectAt(2));
        } else {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
    }

    public static Extension getInstance(Object obj) {
        if (obj instanceof Extension) {
            return (Extension)obj;
        }
        if (obj != null) {
            return new Extension(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DERObjectIdentifier getExtnId() {
        return this.extnId;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public ASN1OctetString getExtnValue() {
        return this.value;
    }

    public ASN1Encodable getParsedValue() {
        return Extension.convertValueToObject(this);
    }

    @Override
    public int hashCode() {
        if (this.isCritical()) {
            return this.getExtnValue().hashCode() ^ this.getExtnId().hashCode();
        }
        return ~(this.getExtnValue().hashCode() ^ this.getExtnId().hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension other = (Extension)o;
        return other.getExtnId().equals(this.getExtnId()) && other.getExtnValue().equals(this.getExtnValue()) && other.isCritical() == this.isCritical();
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.extnId);
        if (this.critical) {
            v.add(DERBoolean.getInstance(true));
        }
        v.add(this.value);
        return new DERSequence(v);
    }

    private static ASN1Object convertValueToObject(Extension ext) throws IllegalArgumentException {
        try {
            return ASN1Object.fromByteArray(ext.getExtnValue().getOctets());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't convert extension: " + e);
        }
    }
}

