/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERString;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.x509.X509DefaultEntryConverter;
import kz.gamma.asn1.x509.X509NameEntryConverter;
import kz.gamma.asn1.x509.X509NameTokenizer;
import kz.gamma.util.Strings;
import kz.gamma.util.encoders.Hex;

public class X509Name
extends ASN1Encodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier STREET = new DERObjectIdentifier("2.5.4.9");
    public static final DERObjectIdentifier SERIALNUMBER = SN;
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
    public static final DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
    public static final DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
    public static final DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
    public static final DERObjectIdentifier UNIQUE_IDENTIFIER = new DERObjectIdentifier("2.5.4.45");
    public static final DERObjectIdentifier BUSINESS_CATEGORY = new DERObjectIdentifier("2.5.4.15");
    public static final DERObjectIdentifier POSTAL_CODE = new DERObjectIdentifier("2.5.4.17");
    public static final DERObjectIdentifier DN_QUALIFIER = new DERObjectIdentifier("2.5.4.46");
    public static final DERObjectIdentifier PSEUDONYM = new DERObjectIdentifier("2.5.4.65");
    public static final DERObjectIdentifier DATE_OF_BIRTH = new DERObjectIdentifier("1.3.6.1.5.5.7.9.1");
    public static final DERObjectIdentifier PLACE_OF_BIRTH = new DERObjectIdentifier("1.3.6.1.5.5.7.9.2");
    public static final DERObjectIdentifier GENDER = new DERObjectIdentifier("1.3.6.1.5.5.7.9.3");
    public static final DERObjectIdentifier COUNTRY_OF_CITIZENSHIP = new DERObjectIdentifier("1.3.6.1.5.5.7.9.4");
    public static final DERObjectIdentifier COUNTRY_OF_RESIDENCE = new DERObjectIdentifier("1.3.6.1.5.5.7.9.5");
    public static final DERObjectIdentifier NAME_AT_BIRTH = new DERObjectIdentifier("1.3.36.8.3.14");
    public static final DERObjectIdentifier POSTAL_ADDRESS = new DERObjectIdentifier("2.5.4.16");
    public static final DERObjectIdentifier EmailAddress = PKCSObjectIdentifiers.pkcs_9_at_emailAddress;
    public static final DERObjectIdentifier UnstructuredName = PKCSObjectIdentifiers.pkcs_9_at_unstructuredName;
    public static final DERObjectIdentifier UnstructuredAddress = PKCSObjectIdentifiers.pkcs_9_at_unstructuredAddress;
    public static final DERObjectIdentifier E = EmailAddress;
    public static final DERObjectIdentifier DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
    public static final DERObjectIdentifier UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
    public static Hashtable OIDLookUp = new Hashtable();
    public static boolean DefaultReverse = false;
    public static Hashtable DefaultSymbols = OIDLookUp;
    public static Hashtable RFC2253Symbols = new Hashtable();
    public static Hashtable RFC1779Symbols = new Hashtable();
    public static Hashtable SymbolLookUp = new Hashtable();
    public static Hashtable DefaultLookUp = SymbolLookUp;
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private X509NameEntryConverter converter = null;
    private Vector ordering = new Vector();
    private Vector values = new Vector();
    private Vector added = new Vector();
    private ASN1Sequence seq;

    public static X509Name getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X509Name.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static X509Name getInstance(Object obj) {
        if (obj == null || obj instanceof X509Name) {
            return (X509Name)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory \"" + obj.getClass().getName() + "\"");
    }

    public X509Name(ASN1Sequence seq) {
        this.seq = seq;
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Set set = ASN1Set.getInstance(e.nextElement());
            for (int i = 0; i < set.size(); ++i) {
                ASN1Sequence s = ASN1Sequence.getInstance(set.getObjectAt(i));
                if (s.size() != 2) {
                    throw new IllegalArgumentException("badly sized pair");
                }
                this.ordering.addElement(DERObjectIdentifier.getInstance(s.getObjectAt(0)));
                DEREncodable value = s.getObjectAt(1);
                if (value instanceof DERString) {
                    this.values.addElement(((DERString)((Object)value)).getString());
                } else {
                    this.values.addElement("#" + this.bytesToString(Hex.encode(value.getDERObject().getDEREncoded())));
                }
                this.added.addElement(i != 0 ? TRUE : FALSE);
            }
        }
    }

    public X509Name(Hashtable attributes) {
        this(null, attributes);
    }

    public X509Name(Vector ordering, Hashtable attributes) {
        this(ordering, attributes, (X509NameEntryConverter)new X509DefaultEntryConverter());
    }

    public X509Name(Vector ordering, Hashtable attributes, X509NameEntryConverter converter) {
        int i;
        this.converter = converter;
        if (ordering != null) {
            for (i = 0; i != ordering.size(); ++i) {
                this.ordering.addElement(ordering.elementAt(i));
                this.added.addElement(FALSE);
            }
        } else {
            Enumeration e = attributes.keys();
            while (e.hasMoreElements()) {
                this.ordering.addElement(e.nextElement());
                this.added.addElement(FALSE);
            }
        }
        for (i = 0; i != this.ordering.size(); ++i) {
            DERObjectIdentifier oid = (DERObjectIdentifier)this.ordering.elementAt(i);
            if (attributes.get(oid) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + oid.getId() + " - passed to distinguished name");
            }
            this.values.addElement(attributes.get(oid));
        }
    }

    public X509Name(Vector oids, Vector values) {
        this(oids, values, (X509NameEntryConverter)new X509DefaultEntryConverter());
    }

    public X509Name(Vector oids, Vector values, X509NameEntryConverter converter) {
        this.converter = converter;
        if (oids.size() != values.size()) {
            throw new IllegalArgumentException("oids vector must be same length as values.");
        }
        for (int i = 0; i < oids.size(); ++i) {
            this.ordering.addElement(oids.elementAt(i));
            this.values.addElement(values.elementAt(i));
            this.added.addElement(FALSE);
        }
    }

    public X509Name(String dirName) {
        this(DefaultReverse, DefaultLookUp, dirName);
    }

    public X509Name(String dirName, X509NameEntryConverter converter) {
        this(DefaultReverse, DefaultLookUp, dirName, converter);
    }

    public X509Name(boolean reverse, String dirName) {
        this(reverse, DefaultLookUp, dirName);
    }

    public X509Name(boolean reverse, String dirName, X509NameEntryConverter converter) {
        this(reverse, DefaultLookUp, dirName, converter);
    }

    public X509Name(boolean reverse, Hashtable lookUp, String dirName) {
        this(reverse, lookUp, dirName, new X509DefaultEntryConverter());
    }

    private DERObjectIdentifier decodeOID(String name, Hashtable lookUp) {
        if (Strings.toUpperCase(name).startsWith("OID.")) {
            return new DERObjectIdentifier(name.substring(4));
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            return new DERObjectIdentifier(name);
        }
        DERObjectIdentifier oid = (DERObjectIdentifier)lookUp.get(Strings.toLowerCase(name));
        if (oid == null) {
            throw new IllegalArgumentException("Unknown object id - " + name + " - passed to distinguished name");
        }
        return oid;
    }

    public X509Name(boolean reverse, Hashtable lookUp, String dirName, X509NameEntryConverter converter) {
        this.converter = converter;
        X509NameTokenizer nTok = new X509NameTokenizer(dirName);
        while (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            if (token.indexOf(43) > 0) {
                X509NameTokenizer pTok = new X509NameTokenizer(token, '+');
                this.addEntry(lookUp, pTok.nextToken(), FALSE);
                while (pTok.hasMoreTokens()) {
                    this.addEntry(lookUp, pTok.nextToken(), TRUE);
                }
                continue;
            }
            this.addEntry(lookUp, token, FALSE);
        }
        if (reverse) {
            Vector o = new Vector();
            Vector v = new Vector();
            Vector a = new Vector();
            int count = 1;
            for (int i = 0; i < this.ordering.size(); ++i) {
                if (((Boolean)this.added.elementAt(i)).booleanValue()) {
                    o.insertElementAt(this.ordering.elementAt(i), count);
                    v.insertElementAt(this.values.elementAt(i), count);
                    a.insertElementAt(this.added.elementAt(i), count);
                    ++count;
                    continue;
                }
                o.insertElementAt(this.ordering.elementAt(i), 0);
                v.insertElementAt(this.values.elementAt(i), 0);
                a.insertElementAt(this.added.elementAt(i), 0);
                count = 1;
            }
            this.ordering = o;
            this.values = v;
            this.added = a;
        }
    }

    private void addEntry(Hashtable lookUp, String token, Boolean isAdded) {
        X509NameTokenizer vTok = new X509NameTokenizer(token, '=');
        String name = vTok.nextToken();
        if (!vTok.hasMoreTokens()) {
            throw new IllegalArgumentException("badly formatted directory string");
        }
        String value = vTok.nextToken();
        DERObjectIdentifier oid = this.decodeOID(name, lookUp);
        this.ordering.addElement(oid);
        this.values.addElement(value);
        this.added.addElement(isAdded);
    }

    private String unescape(String elt) {
        if (elt.length() == 0 || elt.indexOf(92) < 0 && elt.indexOf(34) < 0) {
            return elt.trim();
        }
        char[] elts = elt.toCharArray();
        boolean escaped = false;
        boolean quoted = false;
        StringBuffer buf = new StringBuffer(elt.length());
        int start = 0;
        if (elts[0] == '\\' && elts[1] == '#') {
            start = 2;
            buf.append("\\#");
        }
        boolean nonWhiteSpaceEncountered = false;
        int lastEscaped = 0;
        for (int i = start; i != elts.length; ++i) {
            char c = elts[i];
            if (c != ' ') {
                nonWhiteSpaceEncountered = true;
            }
            if (c == '\"') {
                if (!escaped) {
                    quoted = !quoted;
                } else {
                    buf.append(c);
                }
                escaped = false;
                continue;
            }
            if (c == '\\' && !escaped && !quoted) {
                escaped = true;
                lastEscaped = buf.length();
                continue;
            }
            if (c == ' ' && !escaped && !nonWhiteSpaceEncountered) continue;
            buf.append(c);
            escaped = false;
        }
        if (buf.length() > 0) {
            while (buf.charAt(buf.length() - 1) == ' ' && lastEscaped != buf.length() - 1) {
                buf.setLength(buf.length() - 1);
            }
        }
        return buf.toString();
    }

    public Vector getOIDs() {
        Vector v = new Vector();
        for (int i = 0; i != this.ordering.size(); ++i) {
            v.addElement(this.ordering.elementAt(i));
        }
        return v;
    }

    public Vector getValues() {
        Vector v = new Vector();
        for (int i = 0; i != this.values.size(); ++i) {
            v.addElement(this.values.elementAt(i));
        }
        return v;
    }

    public Vector getValues(DERObjectIdentifier oid) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i != this.values.size(); ++i) {
            if (!this.ordering.elementAt(i).equals(oid)) continue;
            String val = (String)this.values.elementAt(i);
            if (val.length() > 2 && val.charAt(0) == '\\' && val.charAt(1) == '#') {
                v.addElement(val.substring(1));
                continue;
            }
            v.addElement(val);
        }
        return v;
    }

    @Override
    public DERObject toASN1Object() {
        if (this.seq == null) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            ASN1EncodableVector sVec = new ASN1EncodableVector();
            DERObjectIdentifier lstOid = null;
            for (int i = 0; i != this.ordering.size(); ++i) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                DERObjectIdentifier oid = (DERObjectIdentifier)this.ordering.elementAt(i);
                v.add(oid);
                String str = (String)this.values.elementAt(i);
                v.add(this.converter.getConvertedValue(oid, str));
                if (lstOid == null || ((Boolean)this.added.elementAt(i)).booleanValue()) {
                    sVec.add(new DERSequence(v));
                } else {
                    vec.add(new DERSet(sVec));
                    sVec = new ASN1EncodableVector();
                    sVec.add(new DERSequence(v));
                }
                lstOid = oid;
            }
            vec.add(new DERSet(sVec));
            this.seq = new DERSequence(vec);
        }
        return this.seq;
    }

    public boolean equals(Object obj, boolean inOrder) {
        X509Name other;
        if (!inOrder) {
            return this.equals(obj);
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof X509Name) && !(obj instanceof ASN1Sequence)) {
            return false;
        }
        DERObject derO = ((DEREncodable)obj).getDERObject();
        if (this.getDERObject().equals(derO)) {
            return true;
        }
        try {
            other = X509Name.getInstance(obj);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        int orderingSize = this.ordering.size();
        if (orderingSize != other.ordering.size()) {
            return false;
        }
        for (int i = 0; i < orderingSize; ++i) {
            DERObjectIdentifier oOid;
            DERObjectIdentifier oid = (DERObjectIdentifier)this.ordering.elementAt(i);
            if (oid.equals(oOid = (DERObjectIdentifier)other.ordering.elementAt(i))) {
                String oValue;
                String value = (String)this.values.elementAt(i);
                if (this.equivalentStrings(value, oValue = (String)other.values.elementAt(i))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        int delta;
        int end;
        int start;
        X509Name other;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof X509Name) && !(obj instanceof ASN1Sequence)) {
            return false;
        }
        DERObject derO = ((DEREncodable)obj).getDERObject();
        if (this.getDERObject().equals(derO)) {
            return true;
        }
        try {
            other = X509Name.getInstance(obj);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        int orderingSize = this.ordering.size();
        if (orderingSize != other.ordering.size()) {
            return false;
        }
        boolean[] indexes = new boolean[orderingSize];
        if (this.ordering.elementAt(0).equals(other.ordering.elementAt(0))) {
            start = 0;
            end = orderingSize;
            delta = 1;
        } else {
            start = orderingSize - 1;
            end = -1;
            delta = -1;
        }
        for (int i = start; i != end; i += delta) {
            boolean found = false;
            DERObjectIdentifier oid = (DERObjectIdentifier)this.ordering.elementAt(i);
            String value = (String)this.values.elementAt(i);
            for (int j = 0; j < orderingSize; ++j) {
                String oValue;
                DERObjectIdentifier oOid;
                if (indexes[j] || !oid.equals(oOid = (DERObjectIdentifier)other.ordering.elementAt(j)) || !this.equivalentStrings(value, oValue = (String)other.values.elementAt(j))) continue;
                indexes[j] = true;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean equivalentStrings(String s1, String s2) {
        String oValue;
        String value = Strings.toLowerCase(s1.trim());
        return value.equals(oValue = Strings.toLowerCase(s2.trim())) || (value = this.stripInternalSpaces(value)).equals(oValue = this.stripInternalSpaces(oValue));
    }

    private String stripInternalSpaces(String str) {
        StringBuffer res = new StringBuffer();
        if (str.length() != 0) {
            char c1 = str.charAt(0);
            res.append(c1);
            for (int k = 1; k < str.length(); ++k) {
                char c2 = str.charAt(k);
                if (c1 != ' ' || c2 != ' ') {
                    res.append(c2);
                }
                c1 = c2;
            }
        }
        return res.toString();
    }

    @Override
    public int hashCode() {
        ASN1Sequence seq = (ASN1Sequence)this.getDERObject();
        Enumeration e = seq.getObjects();
        int hashCode = 0;
        while (e.hasMoreElements()) {
            hashCode ^= e.nextElement().hashCode();
        }
        return hashCode;
    }

    private void appendValue(StringBuffer buf, Hashtable oidSymbols, DERObjectIdentifier oid, String value) {
        String sym = (String)oidSymbols.get(oid);
        if (sym != null) {
            buf.append(sym);
        } else {
            buf.append(oid.getId());
        }
        buf.append('=');
        int start = buf.length();
        buf.append(value);
        int end = buf.length();
        if (value.length() >= 2 && value.charAt(0) == '\\' && value.charAt(1) == '#') {
            start += 2;
        }
        while (start < end && buf.charAt(start) == ' ') {
            buf.insert(start, "\\");
            start += 2;
            ++end;
        }
        while (--end > start && buf.charAt(end) == ' ') {
            buf.insert(end, '\\');
        }
        block5: while (start <= end) {
            switch (buf.charAt(start)) {
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    buf.insert(start, "\\");
                    start += 2;
                    ++end;
                    continue block5;
                }
            }
            ++start;
        }
    }

    public String toString(boolean reverse, Hashtable oidSymbols) {
        int i;
        StringBuffer buf = new StringBuffer();
        Vector<StringBuffer> components = new Vector<StringBuffer>();
        boolean first = true;
        StringBuffer ava = null;
        for (i = 0; i < this.ordering.size(); ++i) {
            if (((Boolean)this.added.elementAt(i)).booleanValue()) {
                ava.append('+');
                this.appendValue(ava, oidSymbols, (DERObjectIdentifier)this.ordering.elementAt(i), (String)this.values.elementAt(i));
                continue;
            }
            ava = new StringBuffer();
            this.appendValue(ava, oidSymbols, (DERObjectIdentifier)this.ordering.elementAt(i), (String)this.values.elementAt(i));
            components.addElement(ava);
        }
        if (reverse) {
            for (i = components.size() - 1; i >= 0; --i) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(components.elementAt(i).toString());
            }
        } else {
            for (i = 0; i < components.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(components.elementAt(i).toString());
            }
        }
        return buf.toString();
    }

    private String bytesToString(byte[] data) {
        char[] cs = new char[data.length];
        for (int i = 0; i != cs.length; ++i) {
            cs[i] = (char)(data[i] & 0xFF);
        }
        return new String(cs);
    }

    public String toString() {
        return this.toString(DefaultReverse, DefaultSymbols);
    }

    static {
        DefaultSymbols.put(C, "C");
        DefaultSymbols.put(O, "O");
        DefaultSymbols.put(T, "T");
        DefaultSymbols.put(OU, "OU");
        DefaultSymbols.put(CN, "CN");
        DefaultSymbols.put(L, "L");
        DefaultSymbols.put(ST, "ST");
        DefaultSymbols.put(SN, "SERIALNUMBER");
        DefaultSymbols.put(EmailAddress, "E");
        DefaultSymbols.put(DC, "DC");
        DefaultSymbols.put(UID, "UID");
        DefaultSymbols.put(STREET, "STREET");
        DefaultSymbols.put(SURNAME, "SURNAME");
        DefaultSymbols.put(GIVENNAME, "GIVENNAME");
        DefaultSymbols.put(INITIALS, "INITIALS");
        DefaultSymbols.put(GENERATION, "GENERATION");
        DefaultSymbols.put(UnstructuredAddress, "unstructuredAddress");
        DefaultSymbols.put(UnstructuredName, "unstructuredName");
        DefaultSymbols.put(UNIQUE_IDENTIFIER, "UniqueIdentifier");
        DefaultSymbols.put(DN_QUALIFIER, "DN");
        DefaultSymbols.put(PSEUDONYM, "Pseudonym");
        DefaultSymbols.put(POSTAL_ADDRESS, "PostalAddress");
        DefaultSymbols.put(NAME_AT_BIRTH, "NameAtBirth");
        DefaultSymbols.put(COUNTRY_OF_CITIZENSHIP, "CountryOfCitizenship");
        DefaultSymbols.put(COUNTRY_OF_RESIDENCE, "CountryOfResidence");
        DefaultSymbols.put(GENDER, "Gender");
        DefaultSymbols.put(PLACE_OF_BIRTH, "PlaceOfBirth");
        DefaultSymbols.put(DATE_OF_BIRTH, "DateOfBirth");
        DefaultSymbols.put(POSTAL_CODE, "PostalCode");
        DefaultSymbols.put(BUSINESS_CATEGORY, "BusinessCategory");
        RFC2253Symbols.put(C, "C");
        RFC2253Symbols.put(O, "O");
        RFC2253Symbols.put(OU, "OU");
        RFC2253Symbols.put(CN, "CN");
        RFC2253Symbols.put(L, "L");
        RFC2253Symbols.put(ST, "ST");
        RFC2253Symbols.put(STREET, "STREET");
        RFC2253Symbols.put(DC, "DC");
        RFC2253Symbols.put(UID, "UID");
        RFC1779Symbols.put(C, "C");
        RFC1779Symbols.put(O, "O");
        RFC1779Symbols.put(OU, "OU");
        RFC1779Symbols.put(CN, "CN");
        RFC1779Symbols.put(L, "L");
        RFC1779Symbols.put(ST, "ST");
        RFC1779Symbols.put(STREET, "STREET");
        DefaultLookUp.put("c", C);
        DefaultLookUp.put("o", O);
        DefaultLookUp.put("t", T);
        DefaultLookUp.put("ou", OU);
        DefaultLookUp.put("cn", CN);
        DefaultLookUp.put("l", L);
        DefaultLookUp.put("st", ST);
        DefaultLookUp.put("sn", SN);
        DefaultLookUp.put("serialnumber", SN);
        DefaultLookUp.put("street", STREET);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("dc", DC);
        DefaultLookUp.put("e", E);
        DefaultLookUp.put("uid", UID);
        DefaultLookUp.put("surname", SURNAME);
        DefaultLookUp.put("givenname", GIVENNAME);
        DefaultLookUp.put("initials", INITIALS);
        DefaultLookUp.put("generation", GENERATION);
        DefaultLookUp.put("unstructuredaddress", UnstructuredAddress);
        DefaultLookUp.put("unstructuredname", UnstructuredName);
        DefaultLookUp.put("uniqueidentifier", UNIQUE_IDENTIFIER);
        DefaultLookUp.put("dn", DN_QUALIFIER);
        DefaultLookUp.put("pseudonym", PSEUDONYM);
        DefaultLookUp.put("postaladdress", POSTAL_ADDRESS);
        DefaultLookUp.put("nameofbirth", NAME_AT_BIRTH);
        DefaultLookUp.put("countryofcitizenship", COUNTRY_OF_CITIZENSHIP);
        DefaultLookUp.put("countryofresidence", COUNTRY_OF_RESIDENCE);
        DefaultLookUp.put("gender", GENDER);
        DefaultLookUp.put("placeofbirth", PLACE_OF_BIRTH);
        DefaultLookUp.put("dateofbirth", DATE_OF_BIRTH);
        DefaultLookUp.put("postalcode", POSTAL_CODE);
        DefaultLookUp.put("businesscategory", BUSINESS_CATEGORY);
    }
}

