/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import kz.gamma.asn1.ASN1OutputStream;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.cms.AttributeTable;
import kz.gamma.asn1.cms.ContentInfo;
import kz.gamma.asn1.cms.EncryptedContentInfo;
import kz.gamma.asn1.cms.EnvelopedData;
import kz.gamma.asn1.cms.KEKRecipientInfo;
import kz.gamma.asn1.cms.KeyAgreeRecipientInfo;
import kz.gamma.asn1.cms.KeyTransRecipientInfo;
import kz.gamma.asn1.cms.PasswordRecipientInfo;
import kz.gamma.asn1.cms.RecipientInfo;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.cms.CMSEnvelopedHelper;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSUtils;
import kz.gamma.cms.KEKRecipientInformation;
import kz.gamma.cms.KeyAgreeRecipientInformation;
import kz.gamma.cms.KeyTransRecipientInformation;
import kz.gamma.cms.PasswordRecipientInformation;
import kz.gamma.cms.RecipientInformation;
import kz.gamma.cms.RecipientInformationStore;

public class CMSEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier encAlg;
    private ASN1Set unprotectedAttributes;
    private AlgorithmIdentifier _encAlg;

    public CMSEnvelopedData(byte[] envelopedData) throws CMSException {
        this(CMSUtils.readContentInfo(envelopedData));
    }

    public CMSEnvelopedData(InputStream envelopedData) throws CMSException {
        this(CMSUtils.readContentInfo(envelopedData));
    }

    public CMSEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        EnvelopedData envData = EnvelopedData.getInstance(contentInfo.getContent());
        EncryptedContentInfo encInfo = envData.getEncryptedContentInfo();
        this._encAlg = encInfo.getContentEncryptionAlgorithm();
        ASN1Set s = envData.getRecipientInfos();
        ArrayList<RecipientInformation> infos = new ArrayList<RecipientInformation>();
        for (int i = 0; i != s.size(); ++i) {
            RecipientInfo info = RecipientInfo.getInstance(s.getObjectAt(i));
            DEREncodable type = info.getInfo();
            if (type instanceof KeyTransRecipientInfo) {
                infos.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)type, this._encAlg, (InputStream)new ByteArrayInputStream(encInfo.getEncryptedContent().getOctets())));
                continue;
            }
            if (type instanceof KEKRecipientInfo) {
                infos.add(new KEKRecipientInformation((KEKRecipientInfo)type, this._encAlg, (InputStream)new ByteArrayInputStream(encInfo.getEncryptedContent().getOctets())));
                continue;
            }
            if (type instanceof KeyAgreeRecipientInfo) {
                infos.add(new KeyAgreeRecipientInformation((KeyAgreeRecipientInfo)type, this._encAlg, (InputStream)new ByteArrayInputStream(encInfo.getEncryptedContent().getOctets())));
                continue;
            }
            if (!(type instanceof PasswordRecipientInfo)) continue;
            infos.add(new PasswordRecipientInformation((PasswordRecipientInfo)type, this._encAlg, (InputStream)new ByteArrayInputStream(encInfo.getEncryptedContent().getOctets())));
        }
        this.encAlg = envData.getEncryptedContentInfo().getContentEncryptionAlgorithm();
        this.recipientInfoStore = new RecipientInformationStore(infos);
        this.unprotectedAttributes = envData.getUnprotectedAttrs();
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(obj);
            return bOut.toByteArray();
        }
        return null;
    }

    public String getEncryptionAlgOID() {
        return this.encAlg.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getEncryptionAlgOID(), this.getEncryptionAlgParams(), provider);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() {
        if (this.unprotectedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unprotectedAttributes);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(this.contentInfo);
        return bOut.toByteArray();
    }
}

