/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Object;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.cms.IssuerAndSerialNumber;
import kz.gamma.asn1.cms.KEKIdentifier;
import kz.gamma.asn1.cms.KEKRecipientInfo;
import kz.gamma.asn1.cms.KeyAgreeRecipientIdentifier;
import kz.gamma.asn1.cms.KeyAgreeRecipientInfo;
import kz.gamma.asn1.cms.KeyTransRecipientInfo;
import kz.gamma.asn1.cms.OriginatorIdentifierOrKey;
import kz.gamma.asn1.cms.OriginatorPublicKey;
import kz.gamma.asn1.cms.PasswordRecipientInfo;
import kz.gamma.asn1.cms.RecipientEncryptedKey;
import kz.gamma.asn1.cms.RecipientIdentifier;
import kz.gamma.asn1.cms.RecipientInfo;
import kz.gamma.asn1.kisa.KISAObjectIdentifiers;
import kz.gamma.asn1.ntt.NTTObjectIdentifiers;
import kz.gamma.asn1.pkcs.PBKDF2Params;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.asn1.x509.TBSCertificateStructure;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.asn1.x9.X9ObjectIdentifiers;
import kz.gamma.cms.CMSEnvelopedHelper;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSPBEKey;
import kz.gamma.jce.PrincipalUtil;

public class CMSEnvelopedGenerator {
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String CAMELLIA128_CBC = NTTObjectIdentifiers.id_camellia128_cbc.getId();
    public static final String CAMELLIA192_CBC = NTTObjectIdentifiers.id_camellia192_cbc.getId();
    public static final String CAMELLIA256_CBC = NTTObjectIdentifiers.id_camellia256_cbc.getId();
    public static final String SEED_CBC = KISAObjectIdentifiers.id_seedCBC.getId();
    public static final String DES_EDE3_WRAP = PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId();
    public static final String CAMELLIA128_WRAP = NTTObjectIdentifiers.id_camellia128_wrap.getId();
    public static final String CAMELLIA192_WRAP = NTTObjectIdentifiers.id_camellia192_wrap.getId();
    public static final String CAMELLIA256_WRAP = NTTObjectIdentifiers.id_camellia256_wrap.getId();
    public static final String SEED_WRAP = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId();
    public static final String ECDH_SHA1KDF = X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme.getId();
    private static final CMSEnvelopedHelper HELPER = CMSEnvelopedHelper.INSTANCE;
    List recipientInfs = new ArrayList();
    SecureRandom rand = new SecureRandom();

    public void addKeyTransRecipient(X509Certificate cert) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(cert));
    }

    public void addKeyTransRecipient(PublicKey key, byte[] subKeyId) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(key, new DEROctetString(subKeyId)));
    }

    public void addKEKRecipient(SecretKey key, byte[] keyIdentifier) {
        this.recipientInfs.add(new RecipientInf(key, new KEKIdentifier(keyIdentifier, null, null)));
    }

    public void addPasswordRecipient(CMSPBEKey pbeKey, String kekAlgorithmOid) {
        PBKDF2Params params = new PBKDF2Params(pbeKey.getSalt(), pbeKey.getIterationCount());
        this.recipientInfs.add(new RecipientInf((SecretKey)new SecretKeySpec(pbeKey.getEncoded(kekAlgorithmOid), kekAlgorithmOid), new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, params)));
    }

    public void addKeyAgreementRecipient(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, X509Certificate recipientCert, String cekWrapAlgorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement agreement = KeyAgreement.getInstance(agreementAlgorithm, provider);
        agreement.init(senderPrivateKey);
        agreement.doPhase(recipientCert.getPublicKey(), true);
        try {
            SubjectPublicKeyInfo oPubKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(senderPublicKey.getEncoded()));
            OriginatorIdentifierOrKey originator = new OriginatorIdentifierOrKey(new OriginatorPublicKey(new AlgorithmIdentifier(oPubKeyInfo.getAlgorithmId().getObjectId(), new DERNull()), oPubKeyInfo.getPublicKeyData().getBytes()));
            this.recipientInfs.add(new RecipientInf(agreement.generateSecret(cekWrapAlgorithm), agreementAlgorithm, cekWrapAlgorithm, originator, recipientCert));
        }
        catch (IOException e) {
            throw new InvalidKeyException("cannot extract originator public key: " + e);
        }
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String encryptionOID, AlgorithmParameters params) throws IOException {
        DERObject asn1Params;
        if (params != null) {
            ASN1InputStream aIn = new ASN1InputStream(params.getEncoded("ASN.1"));
            asn1Params = aIn.readObject();
        } else {
            asn1Params = new DERNull();
        }
        AlgorithmIdentifier encAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(encryptionOID), asn1Params);
        return encAlgId;
    }

    protected AlgorithmParameters generateParameters(String encryptionOID, SecretKey encKey, String encProvider) throws NoSuchProviderException, CMSException {
        try {
            AlgorithmParameterGenerator pGen = AlgorithmParameterGenerator.getInstance(encryptionOID, encProvider);
            if (encryptionOID.equals(RC2_CBC)) {
                byte[] iv = new byte[8];
                this.rand.setSeed(System.currentTimeMillis());
                this.rand.nextBytes(iv);
                try {
                    pGen.init(new RC2ParameterSpec(encKey.getEncoded().length * 8, iv));
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CMSException("parameters generation error: " + e, e);
                }
            }
            return pGen.generateParameters();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    protected class RecipientInf {
        X509Certificate cert;
        AlgorithmIdentifier keyEncAlg;
        PublicKey pubKey;
        ASN1OctetString subKeyId;
        SecretKey secKey;
        KEKIdentifier secKeyId;
        OriginatorIdentifierOrKey originator;
        ASN1OctetString ukm;
        AlgorithmIdentifier derivationAlg;

        RecipientInf(X509Certificate cert) {
            this.cert = cert;
            this.pubKey = cert.getPublicKey();
            try {
                TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Object.fromByteArray(cert.getTBSCertificate()));
                SubjectPublicKeyInfo info = tbs.getSubjectPublicKeyInfo();
                this.keyEncAlg = info.getAlgorithmId();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't extract key algorithm from this cert");
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("can't extract tbs structure from this cert");
            }
        }

        RecipientInf(PublicKey pubKey, ASN1OctetString subKeyId) {
            this.pubKey = pubKey;
            this.subKeyId = subKeyId;
            try {
                SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(pubKey.getEncoded()));
                this.keyEncAlg = info.getAlgorithmId();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't extract key algorithm from this key");
            }
        }

        RecipientInf(SecretKey secKey, KEKIdentifier secKeyId) {
            this.secKey = secKey;
            this.secKeyId = secKeyId;
            if (secKey.getAlgorithm().startsWith("DES")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), new DERNull());
            } else if (secKey.getAlgorithm().startsWith("RC2")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), new DERInteger(58));
            } else if (secKey.getAlgorithm().startsWith("SEED")) {
                this.keyEncAlg = new AlgorithmIdentifier(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
            } else if (secKey.getAlgorithm().startsWith("Camellia")) {
                DERObjectIdentifier wrapOid;
                int length = secKey.getEncoded().length * 8;
                if (length == 128) {
                    wrapOid = NTTObjectIdentifiers.id_camellia128_wrap;
                } else if (length == 192) {
                    wrapOid = NTTObjectIdentifiers.id_camellia192_wrap;
                } else if (length == 256) {
                    wrapOid = NTTObjectIdentifiers.id_camellia256_wrap;
                } else {
                    throw new IllegalArgumentException("illegal keysize in Camellia");
                }
                this.keyEncAlg = new AlgorithmIdentifier(wrapOid);
            } else {
                throw new IllegalArgumentException("unknown algorithm");
            }
        }

        public RecipientInf(SecretKey secretKey, String algorithm, String wrapOid, OriginatorIdentifierOrKey originator, X509Certificate cert) {
            ASN1EncodableVector params = new ASN1EncodableVector();
            params.add(new DERObjectIdentifier(wrapOid));
            params.add(DERNull.INSTANCE);
            this.secKey = secretKey;
            this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier(algorithm), new DERSequence(params));
            this.originator = originator;
            this.cert = cert;
        }

        public RecipientInf(SecretKey secretKey, AlgorithmIdentifier derivationAlg) {
            this.secKey = secretKey;
            this.derivationAlg = derivationAlg;
        }

        RecipientInfo toRecipientInfo(SecretKey key, String prov) throws IOException, GeneralSecurityException {
            if (this.pubKey != null) {
                DEROctetString encKey;
                Cipher keyCipher = HELPER.createAsymmetricCipher(this.keyEncAlg.getObjectId().getId(), prov);
                try {
                    keyCipher.init(3, this.pubKey);
                    encKey = new DEROctetString(keyCipher.wrap(key));
                }
                catch (GeneralSecurityException e) {
                    keyCipher.init(1, this.pubKey);
                    encKey = new DEROctetString(keyCipher.doFinal(key.getEncoded()));
                }
                catch (IllegalStateException e) {
                    keyCipher.init(1, this.pubKey);
                    encKey = new DEROctetString(keyCipher.doFinal(key.getEncoded()));
                }
                catch (UnsupportedOperationException e) {
                    keyCipher.init(1, key);
                    encKey = new DEROctetString(keyCipher.doFinal(key.getEncoded()));
                }
                if (this.cert != null) {
                    ASN1InputStream aIn = new ASN1InputStream(this.cert.getTBSCertificate());
                    TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
                    IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
                    return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(encSid), this.keyEncAlg, encKey));
                }
                return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(this.subKeyId), this.keyEncAlg, encKey));
            }
            if (this.originator != null) {
                Cipher keyCipher = HELPER.createAsymmetricCipher(DERObjectIdentifier.getInstance(ASN1Sequence.getInstance(this.keyEncAlg.getParameters()).getObjectAt(0)).getId(), prov);
                keyCipher.init(3, this.secKey);
                DEROctetString encKey = new DEROctetString(keyCipher.wrap(key));
                RecipientEncryptedKey rKey = new RecipientEncryptedKey(new KeyAgreeRecipientIdentifier(new IssuerAndSerialNumber((X509Name)PrincipalUtil.getIssuerX509Principal(this.cert), this.cert.getSerialNumber())), encKey);
                return new RecipientInfo(new KeyAgreeRecipientInfo(this.originator, this.ukm, this.keyEncAlg, new DERSequence(rKey)));
            }
            if (this.derivationAlg != null) {
                Cipher keyCipher = HELPER.createAsymmetricCipher(HELPER.getRFC3211WrapperName(this.secKey.getAlgorithm()), prov);
                keyCipher.init(3, this.secKey);
                DEROctetString encKey = new DEROctetString(keyCipher.wrap(key));
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(new DERObjectIdentifier(this.secKey.getAlgorithm()));
                v.add(new DEROctetString(keyCipher.getIV()));
                this.keyEncAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, new DERSequence(v));
                return new RecipientInfo(new PasswordRecipientInfo(this.derivationAlg, this.keyEncAlg, encKey));
            }
            Cipher keyCipher = HELPER.createAsymmetricCipher(this.keyEncAlg.getObjectId().getId(), prov);
            keyCipher.init(3, this.secKey);
            DEROctetString encKey = new DEROctetString(keyCipher.wrap(key));
            return new RecipientInfo(new KEKRecipientInfo(this.secKeyId, this.keyEncAlg, encKey));
        }
    }
}

