/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1OctetStringParser;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1SequenceParser;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.ASN1SetParser;
import kz.gamma.asn1.ASN1StreamParser;
import kz.gamma.asn1.BERConstructedOctetString;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cms.Attribute;
import kz.gamma.asn1.cms.AttributeTable;
import kz.gamma.asn1.cms.ContentInfoParser;
import kz.gamma.asn1.cms.EncryptedContentInfo;
import kz.gamma.asn1.cms.EncryptedContentInfoParser;
import kz.gamma.asn1.cms.EnvelopedData;
import kz.gamma.asn1.cms.EnvelopedDataParser;
import kz.gamma.asn1.cms.OriginatorInfo;
import kz.gamma.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.cms.CMSException;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.chiper.GammaGOST28147;
import kz.gamma.crypto.params.KeyParameter;
import kz.gamma.jce.provider.JCEECPrivateKey;
import kz.gamma.x509.X509InstanceGetter;

public class CMSVistaEnvelopedData {
    private List recipientInfos = new LinkedList();
    private ASN1EncodableVector unAttr = new ASN1EncodableVector();
    private AttributeTable unAttrTable = null;
    private int version;
    private X509Name dnSenderIssuer;
    private byte[] exchSenderSn;
    private X509Name exchSenderName;
    X509Certificate exchSenderCert;
    PrivateKey senderKey;
    private List<X509Name> recipientsNames;
    private byte[] content = null;
    private static byte[] h1 = new byte[]{1, 2, 0, 0, 31, 104, 4, 0, 31, 104, 0, 0};
    GammaGOST28147 enc = new GammaGOST28147();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvelopedData generateEnvelopedData(X509Certificate cert, boolean isInclude) throws CertificateEncodingException, IOException {
        ASN1EncodableVector vecRecipientInfos = new ASN1EncodableVector();
        ASN1EncodableVector vecRecipientKey = new ASN1EncodableVector();
        vecRecipientInfos.add(new DERInteger(3));
        ASN1EncodableVector vecSendInfo = new ASN1EncodableVector();
        vecSendInfo.add(new X509Name(cert.getIssuerDN().toString()));
        vecSendInfo.add(new DERInteger(cert.getSerialNumber()));
        vecRecipientInfos.add(new DERTaggedObject(0, new DERSequence(vecSendInfo)));
        vecRecipientInfos.add(new AlgorithmIdentifier(GammaObjectIndentifiers.tumardh, new DERNull()));
        for (RecipientInfoGamma recipient : this.recipientInfos) {
            vecRecipientKey.add(recipient.toASN1Object());
        }
        vecRecipientInfos.add(new DERSequence(vecRecipientKey));
        OriginatorInfo originatorInfo = null;
        if (isInclude) {
            ASN1InputStream inStr = null;
            try {
                inStr = new ASN1InputStream(cert.getEncoded());
                originatorInfo = new OriginatorInfo(new DERSet(inStr.readObject()), null);
            }
            finally {
                if (inStr != null) {
                    try {
                        inStr.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new DERObjectIdentifier("1.2.840.113549.1.7.3"), new AlgorithmIdentifier(GammaObjectIndentifiers.gost28147, new DERNull()), this.content == null ? null : new BERConstructedOctetString(this.content));
        this.unAttr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.8"), new DERSet(new X509Name(cert.getSubjectDN().getName()))));
        this.unAttr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.5"), new DERSet(new DERGeneralizedTime(new Date()))));
        return new EnvelopedData(originatorInfo, new DERSet(new DERSequence(vecRecipientInfos)), encryptedContentInfo, new DERSet(this.unAttr));
    }

    public void addKeyRecipient(X509Certificate recipientCert) {
        boolean isAdd = false;
        RecipientInfoGamma rec = new RecipientInfoGamma(recipientCert, this.enc);
        this.recipientInfos.add(rec);
        for (int i = 0; i < this.unAttr.size(); ++i) {
            Attribute tmp = (Attribute)this.unAttr.get(0);
            if (!tmp.getAttrType().toString().equals("1.3.6.1.4.1.6801.2.9")) continue;
            ASN1Set asn1Set = tmp.getAttrValues();
            this.unAttr = new ASN1EncodableVector();
            DEREncodableVector derEncodableVector = new DEREncodableVector();
            derEncodableVector.add(asn1Set.getObjectAt(0).getDERObject());
            derEncodableVector.add(new X509Name(recipientCert.getSubjectDN().getName()).toASN1Object());
            DERSet derSet = new DERSet(derEncodableVector);
            this.unAttr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.9"), derSet));
            isAdd = true;
        }
        if (!isAdd) {
            this.unAttr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.9"), new DERSet(new X509Name(recipientCert.getSubjectDN().getName()))));
        }
    }

    public void addUnprotectedAttrs(Attribute attr) {
        this.unAttr.add(attr);
    }

    public CMSVistaEnvelopedData() {
    }

    public CMSVistaEnvelopedData(byte[] cmsDevelopedBuf) throws IOException, NoSuchProviderException, CertificateException, CMSException, NoSuchAlgorithmException {
        ASN1StreamParser as = new ASN1StreamParser(cmsDevelopedBuf);
        ContentInfoParser cP = new ContentInfoParser((ASN1SequenceParser)as.readObject());
        EnvelopedDataParser eP = new EnvelopedDataParser((ASN1SequenceParser)cP.getContent(16));
        this.version = eP.getVersion().getValue().intValue();
        ASN1SetParser certPars = eP.getCertificates();
        if (certPars != null) {
            DERTaggedObject certObject = (DERTaggedObject)certPars.readObject();
            DEREncodable en = certObject.getObjectParser(0, true);
            X509InstanceGetter x509InstanceGetter = new X509InstanceGetter();
            this.exchSenderCert = x509InstanceGetter.getX509CertificateInstance(en.getDERObject().getEncoded());
        }
        DERObject obj = eP.getRecipientInfos().getDERObject();
        DERSequence obj1 = (DERSequence)((DERSet)obj).getObjectAt(0);
        int ver = ((DERInteger)obj1.getObjectAt(0)).getValue().intValue();
        this.dnSenderIssuer = new X509Name((ASN1Sequence)((DERSequence)((DERTaggedObject)obj1.getObjectAt(1)).getObjectParser(0, true)).getObjectAt(0));
        this.exchSenderSn = ((DERInteger)((DERSequence)((DERTaggedObject)obj1.getObjectAt(1)).getObjectParser(0, true)).getObjectAt(1)).getValue().toByteArray();
        this.recipientInfos.clear();
        DERSequence seq = (DERSequence)obj1.getObjectAt(3);
        int count = seq.size();
        for (int i = 0; i < count; ++i) {
            this.recipientInfos.add(new RecipientInfoGamma((DERSequence)seq.getObjectAt(i)));
        }
        EncryptedContentInfoParser ecP = eP.getEncryptedContentInfo();
        try {
            this.content = ((DEROctetString)((ASN1OctetStringParser)ecP.getEncryptedContent(4)).getDERObject()).getOctets();
        }
        catch (NullPointerException e) {
            this.content = null;
        }
        ASN1SetParser prs = eP.getUnprotectedAttrs();
        DEREncodable nextObject = prs.readObject();
        while (nextObject != null) {
            this.unAttr.add(new Attribute((ASN1Sequence)nextObject.getDERObject()));
            nextObject = prs.readObject();
        }
        this.unAttrTable = new AttributeTable(this.unAttr);
        this.exchSenderName = new X509Name((ASN1Sequence)this.getAttributeByOid(this.unAttrTable, "1.3.6.1.4.1.6801.2.8"));
        Attribute at = this.unAttrTable.get(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.9"));
        ASN1Set attrValuesSet = at.getAttrValues();
        this.recipientsNames = new LinkedList<X509Name>();
        for (int i = 0; i < attrValuesSet.size(); ++i) {
            X509Name tmpName = new X509Name((ASN1Sequence)attrValuesSet.getObjectAt(i).getDERObject());
            this.recipientsNames.add(tmpName);
        }
    }

    public DERObject getAttributeByOid(AttributeTable attributeTable, String oid) {
        Attribute at = attributeTable.get(new DERObjectIdentifier(oid));
        DEREncodable obj = at.getAttrValues().getObjectAt(0);
        return obj.getDERObject();
    }

    public byte[] cryptText(byte[] buf) {
        return this.enc.doEncrypt(buf);
    }

    public void genSessionKey(JCEECPrivateKey privKey) {
        this.enc.setHProv(privKey.getHandleProv());
        this.enc.genSesKey(26655);
    }

    public byte[] decryptText(KeyStore store, String password, byte[] crpData, X509Certificate exchSenderCert) {
        this.exchSenderCert = exchSenderCert;
        password = password == null ? "" : password.trim();
        Object ret = null;
        JCEECPrivateKey prKey = null;
        RecipientInfoGamma rInfo2 = null;
        for (RecipientInfoGamma rInfo2 : this.recipientInfos) {
            try {
                prKey = (JCEECPrivateKey)store.getKey(UtilCM.array2hex(rInfo2.snRecipient.getValue().toByteArray()), password.toCharArray());
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (UnrecoverableKeyException e) {
                e.printStackTrace();
            }
            if (prKey == null) continue;
        }
        if (prKey == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430 \u0434\u043b\u044f \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        }
        GammaGOST28147 decr = new GammaGOST28147();
        decr.setHProv(prKey.getHandleProv());
        decr.setSessionKey(rInfo2.keySecret, this.exchSenderCert.getPublicKey().getEncoded());
        byte[] tmp = decr.doDecrypt(crpData);
        return tmp;
    }

    public X509Certificate getExchSenderCert() {
        return this.exchSenderCert;
    }

    public ASN1EncodableVector getUnAttr() {
        return this.unAttr;
    }

    public void initDHParameter(PrivateKey key) {
        this.senderKey = key;
        byte[] secKey = new byte[64];
        byte[] iv = new byte[8];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(secKey);
        secureRandom.nextBytes(iv);
        KeyParameter keyParameter = new KeyParameter(secKey);
    }

    public List getRecipientInfos() {
        return this.recipientInfos;
    }

    public List getRecipientsSerialNumbers() {
        LinkedList<BigInteger> serialNumbers = new LinkedList<BigInteger>();
        for (Object recipientInf : this.recipientInfos) {
            RecipientInfoGamma tmpInfo = (RecipientInfoGamma)recipientInf;
            serialNumbers.add(tmpInfo.snRecipient.getValue());
        }
        return serialNumbers;
    }

    public List<X509Name> getRecipientsNames() {
        return this.recipientsNames;
    }

    public byte[] getExchSenderSn() {
        return this.exchSenderSn;
    }

    public X509Name getExchSenderName() {
        return this.exchSenderName;
    }

    protected class RecipientInfoGamma
    extends ASN1Encodable {
        X509Name dnIssuerRecipient = null;
        DERInteger snRecipient = null;
        byte[] keySecret = null;

        public RecipientInfoGamma(DERSequence der) {
            this.dnIssuerRecipient = new X509Name((ASN1Sequence)((DERSequence)der.getObjectAt(0)).getObjectAt(0));
            this.snRecipient = (DERInteger)((DERSequence)der.getObjectAt(0)).getObjectAt(1);
            this.keySecret = ((DEROctetString)der.getObjectAt(1)).getOctets();
        }

        public RecipientInfoGamma(X509Certificate certRecipient, GammaGOST28147 enc) {
            this.keySecret = enc.getSessionKey(certRecipient.getPublicKey());
            this.dnIssuerRecipient = new X509Name(certRecipient.getIssuerDN().getName());
            this.snRecipient = new DERInteger(certRecipient.getSerialNumber());
        }

        @Override
        public DERObject toASN1Object() {
            ASN1EncodableVector recInfo = new ASN1EncodableVector();
            ASN1EncodableVector infoKeyId = new ASN1EncodableVector();
            infoKeyId.add(this.dnIssuerRecipient);
            infoKeyId.add(this.snRecipient);
            recInfo.add(new DERSequence(infoKeyId));
            BERConstructedOctetString oct = new BERConstructedOctetString(this.keySecret);
            recInfo.add(oct);
            return new DERSequence(recInfo);
        }
    }
}

