/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.core.network;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class RequestSender {
    public static byte[] sendRequest(String serviceURL, byte[] request) {
        return RequestSender.sendRequest(serviceURL, request, "application/pkixcmp", null);
    }

    public static byte[] sendRequest(String serviceURL, byte[] request, String contentType, String requestMethod) {
        FilterOutputStream dataOutputStream = null;
        FilterInputStream dataInputStream = null;
        try {
            int bytesRead;
            HttpURLConnection conn = (HttpURLConnection)new URL(serviceURL).openConnection();
            if (requestMethod != null) {
                conn.setRequestMethod(requestMethod);
            }
            conn.setRequestProperty("Content-Type", contentType);
            conn.setDoOutput(true);
            dataOutputStream = new DataOutputStream(conn.getOutputStream());
            dataOutputStream.write(request);
            ((DataOutputStream)dataOutputStream).flush();
            int responseSize = conn.getContentLength();
            dataInputStream = new DataInputStream(conn.getInputStream());
            byte[] response = new byte[responseSize];
            for (int totalRead = 0; totalRead < responseSize && (bytesRead = ((DataInputStream)dataInputStream).read(response, totalRead, responseSize - totalRead)) >= 0; totalRead += bytesRead) {
            }
            byte[] byArray = response;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot send request");
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String sendRequest(String serviceURL, String request, String contentType, String requestMethod) {
        OutputStreamWriter outputStreamWriter = null;
        boolean outputStreamWriterIsClosed = false;
        BufferedReader bufferedReader = null;
        boolean bufferedReaderIsClosed = false;
        try {
            String decodedString;
            HttpURLConnection connection = (HttpURLConnection)new URL(serviceURL).openConnection();
            if (requestMethod != null) {
                connection.setRequestMethod(requestMethod);
            }
            connection.setRequestProperty("Content-Type", contentType);
            connection.setDoOutput(true);
            outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            outputStreamWriter.write(request);
            outputStreamWriter.close();
            outputStreamWriterIsClosed = true;
            StringBuilder stringBuilder = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((decodedString = bufferedReader.readLine()) != null) {
                stringBuilder.append(decodedString);
            }
            bufferedReader.close();
            bufferedReaderIsClosed = true;
            String string = stringBuilder.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot send request");
        }
        finally {
            if (outputStreamWriter != null && !outputStreamWriterIsClosed) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bufferedReader != null && !bufferedReaderIsClosed) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

