/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.digests;

import kz.gamma.core.UtilCM;
import kz.gamma.crypto.ExtendedDigest;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class GammaGost3411Digest
implements ExtendedDigest {
    private static final String NOT_READY_FOR_UPDATE_MESSAGE = "GammaGost3411Digest is not ready for update. Reset first.";
    private Number hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456, LibraryWrapper.PV_TABLE);
    private Number hHashLocal = 0;
    private int hashAlgId = 32797;
    private boolean readyToUpdate = false;

    public GammaGost3411Digest() {
        this.reset();
    }

    public GammaGost3411Digest(int hAlgID) {
        this.hashAlgId = hAlgID;
        this.reset();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.hHashLocal.longValue() != 0L) {
                TumarCspFunctions.cpDestroyHash(this.hProvLocal, this.hHashLocal);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hHashLocal = 0;
        try {
            if (this.hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(this.hProvLocal, 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hProvLocal = 0;
        super.finalize();
    }

    public GammaGost3411Digest(GammaGost3411Digest t) {
        this.hashAlgId = t.hashAlgId;
        this.reset();
    }

    @Override
    public int getByteLength() {
        int ret = 32;
        try {
            ret = TumarCspFunctions.cpGetHashParamSize(this.hProvLocal, this.hHashLocal, 2, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String getAlgorithmName() {
        if (this.hashAlgId == 32797) {
            return "GOST3411";
        }
        if (this.hashAlgId == 32772) {
            return "SHA1";
        }
        if (this.hashAlgId == 32780) {
            return "SHA256";
        }
        if (this.hashAlgId == 32796) {
            return "TUMAR";
        }
        if (this.hashAlgId == 32789) {
            return "CRYPTOPRO";
        }
        return "GOST3411";
    }

    @Override
    public int getDigestSize() {
        int ret = 32;
        try {
            ret = TumarCspFunctions.cpGetHashParamSize(this.hProvLocal, this.hHashLocal, 2, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public void update(byte in) {
        try {
            if (!this.readyToUpdate) {
                throw new RuntimeException(NOT_READY_FOR_UPDATE_MESSAGE);
            }
            byte[] btn = new byte[]{in};
            TumarCspFunctions.cpHashData(this.hProvLocal, this.hHashLocal, btn, 1, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        try {
            if (!this.readyToUpdate) {
                throw new RuntimeException(NOT_READY_FOR_UPDATE_MESSAGE);
            }
            byte[] btn = UtilCM.copyByte(in, inOff, len);
            TumarCspFunctions.cpHashData(this.hProvLocal, this.hHashLocal, btn, len, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int size = 32;
        this.readyToUpdate = false;
        try {
            size = TumarCspFunctions.cpGetHashParamSize(this.hProvLocal, this.hHashLocal, 2, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (size != 0) {
            byte[] tmp = TumarCspFunctions.cpGetHashParamData(this.hProvLocal, this.hHashLocal, 2, 0);
            System.arraycopy(tmp, 0, out, outOff, tmp.length);
        }
        return size;
    }

    @Override
    public void reset() {
        try {
            TumarCspFunctions.cpDestroyHash(this.hProvLocal, this.hHashLocal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.hHashLocal = TumarCspFunctions.cpCreateHash(this.hProvLocal, this.hashAlgId, (Number)0, 0);
            this.readyToUpdate = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

