/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.idcard;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;

public class IdCard {
    private Map<String, CardChannel> cards = new TreeMap<String, CardChannel>();

    public IdCard() {
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> cardTerminals = factory.terminals().list();
            for (CardTerminal cardTerminal : cardTerminals) {
                CardTerminal terminal = cardTerminal;
                if (!terminal.isCardPresent()) continue;
                Card sc = terminal.connect("*");
                CardChannel cardChannel = sc.getBasicChannel();
                byte[] select = new byte[]{0, -92, 2, 12, 2, 3, 1};
                byte[] next = new byte[]{0, -64, 0, 0, 0};
                CommandAPDU capdu = new CommandAPDU(select);
                ResponseAPDU respApdu = cardChannel.transmit(capdu);
                if (respApdu.getSW() == 36864) {
                    this.cards.put(terminal.getName(), cardChannel);
                    continue;
                }
                if (respApdu.getSW1() == 97) {
                    capdu = new CommandAPDU(next);
                    respApdu = cardChannel.transmit(capdu);
                    if (respApdu.getSW() == 36864) {
                        this.cards.put(terminal.getName(), cardChannel);
                        continue;
                    }
                    System.err.println(terminal.getName() + " error: " + respApdu.getSW());
                    continue;
                }
                System.err.println(terminal.getName() + " error: " + respApdu.getSW());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map getCards() {
        return this.cards;
    }

    public void disconnect() {
        Iterator<Map.Entry<String, CardChannel>> iterator = this.cards.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CardChannel> o;
            Map.Entry<String, CardChannel> entry = o = iterator.next();
            String reader = entry.getKey();
            CardChannel cardChannel = entry.getValue();
            try {
                cardChannel.getCard().disconnect(false);
            }
            catch (CardException e) {
                System.err.println("error on disconnect reader '" + reader + "': " + e.getMessage());
            }
        }
    }
}

