/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.signers;

import kz.gamma.crypto.CipherParameters;
import kz.gamma.crypto.DSA;
import kz.gamma.crypto.params.GammaParameters;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class ECGOST3410Signer
implements DSA {
    private GammaParameters keyParam;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (param instanceof GammaParameters) {
            this.keyParam = (GammaParameters)param;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generateSignature(byte[] message) {
        byte[] rsign = null;
        Number hHash = 0;
        try {
            hHash = TumarCspFunctions.cpCreateHash(this.keyParam.getCSPHandle(), this.keyParam.gethashAlgID(), (Number)0, 0);
            TumarCspFunctions.cpSetHashParam(this.keyParam.getCSPHandle(), hHash, 2, message, 0);
            rsign = TumarCspFunctions.cpSignHashData(this.keyParam.getCSPHandle(), hHash, this.keyParam.getCSPkeyType(), "", 0);
        }
        finally {
            if (hHash.longValue() != 0L) {
                TumarCspFunctions.cpDestroyHash(this.keyParam.getCSPHandle(), hHash);
            }
        }
        return rsign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifySignature(byte[] message, byte[] sign) {
        boolean retCode = false;
        Number hProvLocal = 0;
        Number hPubKey = 0;
        Number hHash = 0;
        try {
            hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456, LibraryWrapper.PV_TABLE);
            hPubKey = TumarCspFunctions.cpImportKey(hProvLocal, this.keyParam.getPublicKey(), this.keyParam.getPublicKey().length, (Number)0, 0);
            hHash = TumarCspFunctions.cpCreateHash(hProvLocal, this.keyParam.gethashAlgID(), (Number)0, 0);
            TumarCspFunctions.cpSetHashParam(hProvLocal, hHash, 2, message, 0);
            int res = TumarCspFunctions.cpVerifySignature(hProvLocal, hHash, sign, sign.length, hPubKey, "", 0);
            if (res != 0) {
                retCode = true;
            }
        }
        catch (Exception e) {
            retCode = false;
        }
        finally {
            if (hPubKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hProvLocal, hPubKey);
            }
            if (hHash.longValue() != 0L) {
                TumarCspFunctions.cpDestroyHash(hProvLocal, hHash);
            }
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
        }
        return retCode;
    }
}

