/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PSSParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.DERBitString;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROutputStream;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gamma.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.asn1.oiw.OIWObjectIdentifiers;
import kz.gamma.asn1.pkcs.CertificationRequest;
import kz.gamma.asn1.pkcs.CertificationRequestInfo;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.pkcs.RSASSAPSSparams;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.asn1.x9.X9ObjectIdentifiers;
import kz.gamma.core.UtilCM;
import kz.gamma.jce.X509Principal;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.util.Strings;

public class PKCS10CertificationRequest
extends CertificationRequest {
    private static Hashtable<Object, Object> algorithms = new Hashtable();
    private static Hashtable<Object, Object> params = new Hashtable();
    private static Hashtable<Object, Object> keyAlgorithms = new Hashtable();
    private static Hashtable<Object, Object> oids = new Hashtable();
    private static Set<Object> noParams = new HashSet<Object>();

    private static RSASSAPSSparams creatPSSParams(AlgorithmIdentifier hashAlgId, int saltSize) {
        return new RSASSAPSSparams(hashAlgId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, hashAlgId), new DERInteger(saltSize), new DERInteger(1));
    }

    private static ASN1Sequence toDERSequence(byte[] bytes) {
        try {
            ASN1InputStream dIn = new ASN1InputStream(bytes);
            return (ASN1Sequence)dIn.readObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public PKCS10CertificationRequest(byte[] bytes) {
        super(PKCS10CertificationRequest.toDERSequence(bytes));
    }

    public PKCS10CertificationRequest(ASN1Sequence sequence) {
        super(sequence);
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X509Name subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, subject, key, attributes, signingKey, GammaTechProvider.PROVIDER_NAME);
    }

    private static X509Name convertName(X500Principal name) {
        try {
            return new X509Principal(name.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't convert name");
        }
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X500Principal subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, PKCS10CertificationRequest.convertName(subject), key, attributes, signingKey, GammaTechProvider.PROVIDER_NAME);
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X500Principal subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, PKCS10CertificationRequest.convertName(subject), key, attributes, signingKey, provider);
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X509Name subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        String algorithmName = Strings.toUpperCase(signatureAlgorithm);
        DERObjectIdentifier sigOID = (DERObjectIdentifier)algorithms.get(algorithmName);
        if (sigOID == null) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        this.sigAlgId = noParams.contains(sigOID) ? new AlgorithmIdentifier(sigOID) : (params.containsKey(algorithmName) ? new AlgorithmIdentifier(sigOID, (DEREncodable)params.get(algorithmName)) : new AlgorithmIdentifier(sigOID, null));
        String alg = key.getAlgorithm();
        byte[] bytes = key.getEncoded();
        try {
            this.reqInfo = alg.equals(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A.getId()) || alg.equals(KZObjectIndentifiers.GOST_34_310_KEY_A.getId()) ? new CertificationRequestInfo(subject, new SubjectPublicKeyInfo((DERSequence)new ASN1InputStream(bytes).readObject()), attributes) : new CertificationRequestInfo(subject, new SubjectPublicKeyInfo(new AlgorithmIdentifier(new DERObjectIdentifier(alg), null), bytes), attributes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature sig = Signature.getInstance(signatureAlgorithm, provider);
        sig.initSign(signingKey);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.reqInfo);
            sig.update(bOut.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + e);
        }
        if (signatureAlgorithm.equals("GOST3411WITHGOST3410-2001")) {
            byte[] sg = sig.sign();
            sg = UtilCM.inverseCopyByte(sg, 0, sg.length);
            this.sigBits = new DERBitString(sg);
        } else {
            this.sigBits = new DERBitString(sig.sign());
        }
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        return this.getPublicKey(GammaTechProvider.PROVIDER_NAME);
    }

    public PublicKey getPublicKey(String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        SubjectPublicKeyInfo subjectPKInfo = this.reqInfo.getSubjectPublicKeyInfo();
        X509EncodedKeySpec xspec = new X509EncodedKeySpec(new DERBitString(subjectPKInfo).getBytes());
        AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithmId();
        try {
            try {
                String str = keyAlg.getObjectId().getId();
                KeyFactory kkey = str.equals(CryptoProObjectIdentifiers.gostR3410_2001.toString()) ? KeyFactory.getInstance(GammaObjectIndentifiers.gost34310_GammaTech_A.toString(), provider) : KeyFactory.getInstance(str, provider);
                return kkey.generatePublic(xspec);
            }
            catch (NoSuchAlgorithmException e) {
                if (keyAlgorithms.get(keyAlg.getObjectId()) != null) {
                    String keyAlgorithm = (String)keyAlgorithms.get(keyAlg.getObjectId());
                    return KeyFactory.getInstance(keyAlgorithm, provider).generatePublic(xspec);
                }
                throw e;
            }
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            throw new InvalidKeyException("error decoding public key");
        }
    }

    public boolean verify() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        return this.verify(GammaTechProvider.PROVIDER_NAME);
    }

    public boolean verify(String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        return this.verify(this.getPublicKey(provider), provider);
    }

    public boolean verify(PublicKey pubKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature sig;
        try {
            String str = PKCS10CertificationRequest.getSignatureName(this.sigAlgId);
            if (str.equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001.getId())) {
                str = "GOST3411WITHGOST3410-2001";
            }
            if (str.equals(KZObjectIndentifiers.GOST_34_310_SIGNATURE.getId())) {
                str = "KZWITHGOST34310";
            }
            sig = Signature.getInstance(str, provider);
        }
        catch (NoSuchAlgorithmException e) {
            if (oids.get(this.sigAlgId.getObjectId()) != null) {
                String signatureAlgorithm = (String)oids.get(this.sigAlgId.getObjectId());
                sig = Signature.getInstance(signatureAlgorithm, provider);
            }
            throw e;
        }
        this.setSignatureParameters(sig, this.sigAlgId.getParameters());
        sig.initVerify(pubKey);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.reqInfo);
            sig.update(bOut.toByteArray());
        }
        catch (Exception e) {
            throw new SignatureException("exception encoding TBS cert request - " + e);
        }
        return sig.verify(this.sigBits.getBytes());
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return bOut.toByteArray();
    }

    private void setSignatureParameters(Signature signature, DEREncodable params) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (params != null && !DERNull.INSTANCE.equals(params)) {
            AlgorithmParameters sigParams = AlgorithmParameters.getInstance(signature.getAlgorithm(), signature.getProvider());
            try {
                sigParams.init(params.getDERObject().getDEREncoded());
            }
            catch (IOException e) {
                throw new SignatureException("IOException decoding parameters: " + e.getMessage());
            }
            if (signature.getAlgorithm().endsWith("MGF1")) {
                try {
                    signature.setParameter(sigParams.getParameterSpec(PSSParameterSpec.class));
                }
                catch (GeneralSecurityException e) {
                    throw new SignatureException("Exception extracting parameters: " + e.getMessage());
                }
            }
        }
    }

    static String getSignatureName(AlgorithmIdentifier sigAlgId) {
        DEREncodable params = sigAlgId.getParameters();
        if (params != null && !DERNull.INSTANCE.equals(params) && sigAlgId.getObjectId().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            RSASSAPSSparams rsaParams = RSASSAPSSparams.getInstance(params);
            return PKCS10CertificationRequest.getDigestAlgName(rsaParams.getHashAlgorithm().getObjectId()) + "withRSAandMGF1";
        }
        return sigAlgId.getObjectId().getId();
    }

    private static String getDigestAlgName(DERObjectIdentifier digestAlgOID) {
        if (PKCSObjectIdentifiers.md5.equals(digestAlgOID)) {
            return "MD5";
        }
        if (OIWObjectIdentifiers.idSHA1.equals(digestAlgOID)) {
            return "SHA1";
        }
        if (GammaObjectIndentifiers.gost34311.equals(digestAlgOID)) {
            return "GOST3411";
        }
        return digestAlgOID.getId();
    }

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD2WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("RSAWITHMD5", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA224WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA224WITHRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA256WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA256WITHRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA384WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA384WITHRSA", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA512WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA512WITHRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA1WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA224WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA256WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA384WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA512WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("RSAWITHSHA1", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("RIPEMD160WITHRSA", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("SHA1WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("SHA224WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224);
        algorithms.put("SHA256WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256);
        algorithms.put("SHA384WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384);
        algorithms.put("SHA512WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512);
        algorithms.put("ECDSAWITHSHA1", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("GOST3411WITHGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3410WITHGOST3411", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHECGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHECGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("KZWITHGOST34310", KZObjectIndentifiers.GOST_34_310_SIGNATURE);
        algorithms.put("ECGOST34310", GammaObjectIndentifiers.gost34310);
        algorithms.put("GOST2012512WITHECGOST3410", GammaObjectIndentifiers.gostR3411_2012_512);
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.5"), "SHA1WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WITHRSA");
        oids.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");
        oids.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3411WITHGOST3410");
        oids.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "GOST3411WITHECGOST3410");
        oids.put(GammaObjectIndentifiers.gostR3411_2012_512, "GOST2012512WITHECGOST3410");
        oids.put(GammaObjectIndentifiers.gost34310, "ECGOST34310");
        oids.put(GammaObjectIndentifiers.gost34310_GammaTech_A, "ECGOST34310");
        oids.put(GammaObjectIndentifiers.gost34310_GammaTech_A_EX, "ECGOST34310");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.4"), "MD5WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.2"), "MD2WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.10040.4.3"), "SHA1WITHDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1WITHECDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA224, "SHA224WITHECDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256WITHECDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384WITHECDSA");
        oids.put(X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512WITHECDSA");
        oids.put(OIWObjectIdentifiers.sha1WithRSA, "SHA1WITHRSA");
        oids.put(OIWObjectIdentifiers.dsaWithSHA1, "SHA1WITHDSA");
        keyAlgorithms.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        keyAlgorithms.put(X9ObjectIdentifiers.id_dsa, "DSA");
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA1);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA224);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA256);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA384);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA512);
        noParams.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        AlgorithmIdentifier sha1AlgId = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, new DERNull());
        params.put("SHA1WITHRSAANDMGF1", PKCS10CertificationRequest.creatPSSParams(sha1AlgId, 20));
    }
}

