/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.security.Provider;
import java.util.Enumeration;
import kz.gamma.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gamma.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.jce.interfaces.ConfigurableProvider;
import kz.gamma.tumarcsp.AlgParamUtil;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public final class GammaTechProvider
extends Provider
implements ConfigurableProvider {
    private static final long serialVersionUID = -8424765061044291492L;
    private static String info = "GammaTech Security Provider v1.38";
    public static String PROVIDER_NAME = "GAMMA";
    public static int PROVIDER_TYPE_DH = 25;
    public static int PROVIDER_TYPE_EC = 25;
    public static int PROVIDER_TYPE_RSA = 1;
    private static boolean isHaveLicense = false;
    public static AlgParamUtil algUtil = null;

    public GammaTechProvider() {
        super(PROVIDER_NAME, 1.38, info);
        Number hProvLocal = 0;
        try {
            hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456, LibraryWrapper.PV_TABLE);
            byte[] result = TumarCspFunctions.cpGetProvParamByte(hProvLocal, 66, 1, 1);
            if (result != null) {
                isHaveLicense = true;
            }
        }
        catch (Exception e) {
            isHaveLicense = false;
        }
        finally {
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
        }
        this.put("MessageDigest.GOST3411", "kz.gamma.jce.provider.JDKMessageDigest$GOST3411");
        this.put("MessageDigest.SHA1", "kz.gamma.jce.provider.JDKMessageDigest$SHA1");
        this.put("MessageDigest.SHA256", "kz.gamma.jce.provider.JDKMessageDigest$SHA256");
        this.put("MessageDigest.TUMAR", "kz.gamma.jce.provider.JDKMessageDigest$TUMAR");
        this.put("MessageDigest.GOSTR3411", "kz.gamma.jce.provider.JDKMessageDigest$CRYPTOPRO");
        this.put("MessageDigest.GOST3411-2012-512", "kz.gamma.jce.provider.JDKMessageDigest$GOST3411_2012_512");
        this.put("MessageDigest.GOST3411-2012-256", "kz.gamma.jce.provider.JDKMessageDigest$GOST3411_2012_256");
        this.put("Alg.Alias.MessageDigest.GOST", "GOST3411");
        this.put("Alg.Alias.MessageDigest.GOST-3411", "GOST3411");
        this.put("Alg.Alias.MessageDigest.GOST2012512", "GOST3411-2012-512");
        this.put("Alg.Alias.MessageDigest.GOST2012256", "GOST3411-2012-256");
        this.put("Alg.Alias.MessageDigest." + CryptoProObjectIdentifiers.gostR3411, "GOST3411");
        this.put("Alg.Alias.MessageDigest." + GammaObjectIndentifiers.gost34311, "GOST3411");
        this.put("Alg.Alias.MessageDigest." + KZObjectIndentifiers.GOST_34_11_95, "GOST3411");
        this.put("Alg.Alias.MessageDigest." + GammaObjectIndentifiers.tumar, "TUMAR");
        this.put("Alg.Alias.MessageDigest." + CryptoProObjectIdentifiers.gostR3411, "GOSTR3411");
        this.put("Alg.Alias.MessageDigest.sha1", "SHA1");
        this.put("KeyPairGenerator.ECGOST34310", "kz.gamma.jce.provider.JDKKeyPairGenerator$ECGOST34310");
        this.put("KeyPairGenerator.RSA", "kz.gamma.jce.provider.JDKKeyPairGenerator$RSA");
        this.put("KeyStore.BIN_BODY", "kz.gamma.jce.provider.JDKKeyStoreBinBody");
        this.put("KeyStore.BIN_BODY_NP", "kz.gamma.jce.provider.JDKKeyStoreBinBodyNP");
        this.put("KeyStore.BIN_PATH", "kz.gamma.jce.provider.JDKKeyStoreBinPath");
        this.put("KeyStore.BIN_PATH_NP", "kz.gamma.jce.provider.JDKKeyStoreBinPathNP");
        this.put("KeyStore.GKS", "kz.gamma.jce.provider.JDKKeyStoreProfile");
        this.put("KeyStore.PKS", "kz.gamma.jce.provider.JDKKeyStoreEx");
        this.put("KeyStore.PKCS12_BODY", "kz.gamma.jce.provider.JDKKeyStorePKCS12Body");
        this.put("KeyStore.PKCS12_BODY_NP", "kz.gamma.jce.provider.JDKKeyStorePKCS12BodyNP");
        this.put("KeyStore.PKCS12", "kz.gamma.jce.provider.JDKKeyStorePKCS12");
        this.put("KeyStore.PKCS12_NP", "kz.gamma.jce.provider.JDKKeyStorePKCS12NP");
        this.put("CertificateFactory.X.509", "kz.gamma.jce.provider.JDKX509CertificateFactory");
        this.put("Alg.Alias.CertificateFactory.X509", "X.509");
        this.put("X509Store.CERTIFICATE/COLLECTION", "kz.gamma.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "kz.gamma.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "kz.gamma.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "kz.gamma.jce.provider.X509StoreCertPairCollection");
        this.put("X509Store.CERTIFICATE/LDAP", "kz.gamma.jce.provider.X509StoreLDAPCerts");
        this.put("X509Store.CRL/LDAP", "kz.gamma.jce.provider.X509StoreLDAPCRLs");
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "kz.gamma.jce.provider.X509StoreLDAPAttrCerts");
        this.put("X509Store.CERTIFICATEPAIR/LDAP", "kz.gamma.jce.provider.X509StoreLDAPCertPairs");
        this.put("X509StreamParser.CERTIFICATE", "kz.gamma.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "kz.gamma.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "kz.gamma.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "kz.gamma.jce.provider.X509CertPairParser");
        this.put("Signature.ECGOST34310", "kz.gamma.jce.provider.JDKGOST3410Signer$ecgost34310");
        this.put("Alg.Alias.Signature.GOST3411withECGOST34310", "ECGOST34310");
        this.put("Alg.Alias.Signature.GOST3411withECGOST3410", "ECGOST34310");
        this.put("Alg.Alias.Signature." + GammaObjectIndentifiers.gost34310, "ECGOST34310");
        this.put("Alg.Alias.Signature.GOST2012512withECGOST3410", "GOST2012512WITHECGOST3410");
        this.put("Alg.Alias.Signature." + GammaObjectIndentifiers.gost3410_2012_512, "GOST2012512WITHECGOST3410");
        this.put("Signature.GOST2012512withECGOST3410", "kz.gamma.jce.provider.JDKGOST3410Signer$gost2012_512");
        this.put("Signature.GOST2012256withECGOST3410", "kz.gamma.jce.provider.JDKGOST3410Signer$gost2012_256");
        this.put("Signature.TUMAR", "kz.gamma.jce.provider.JDKGOST3410Signer$tumar");
        this.put("Alg.Alias.Signature.TUMARwithECGOST34310", "TUMAR");
        this.put("Signature.CRYPTOPRO", "kz.gamma.jce.provider.JDKGOST3410Signer$cryptopro");
        this.put("Signature.KZWITHGOST34310", "kz.gamma.jce.provider.JDKGOST3410Signer$kzgost34310");
        this.put("Alg.Alias.Signature." + KZObjectIndentifiers.GOST_34_310_SIGNATURE, "KZWITHGOST34310");
        this.put("Alg.Alias.Signature.GOST3411WITHGOST3410-2001", "CRYPTOPRO");
        this.put("Alg.Alias.Signature.1.2.643.2.2.9with1.2.643.2.2.19", "CRYPTOPRO");
        this.put("Signature.RSA", "kz.gamma.jce.provider.JDKGOST3410Signer$ecsha1");
        this.put("Signature.SHA256withRSA", "kz.gamma.jce.provider.JDKGOST3410Signer$ecsha256");
        this.put("Alg.Alias.Signature.SHA1withRSA", "RSA");
        this.put("Alg.Alias.Signature.RSAwhisSHA1", "RSA");
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "RSA");
        this.put("KeyFactory.ECGOST34310", "kz.gamma.jce.provider.JDKKeyFactory$ECGOST34310");
        this.put("KeyFactory.CRYPTOPRO", "kz.gamma.jce.provider.JDKKeyFactory$CRYPTOPRO");
        this.setKeyAlgID();
        this.put("CertPathValidator.PKIX", "kz.gamma.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathValidator.PKIX ValidationAlgorithm", "RFC2459");
        this.put("CertPathBuilder.PKIX", "kz.gamma.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertPathBuilder.PKIX ValidationAlgorithm", "RFC2459");
        this.put("CertStore.Collection", "kz.gamma.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "kz.gamma.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "kz.gamma.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    public static AlgParamUtil getAlgUtil() {
        return algUtil;
    }

    public void setKeyAlgID() {
        algUtil = new AlgParamUtil();
        Enumeration<String> en = algUtil.getAlgKey().keys();
        while (en.hasMoreElements()) {
            String oidKey = en.nextElement();
            this.put("Alg.Alias.KeyFactory." + oidKey, "ECGOST34310");
        }
        this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1.1", "ECGOST34310");
        this.put("Alg.Alias.KeyFactory." + GammaObjectIndentifiers.gost34310, "ECGOST34310");
        this.put("Alg.Alias.KeyFactory." + KZObjectIndentifiers.GOST_34_310_KEY, "ECGOST34310");
        this.put("Alg.Alias.KeyFactory.RSA", "ECGOST34310");
        this.put("Alg.Alias.KeyFactory." + CryptoProObjectIdentifiers.gostR3410_2001, "CRYPTOPRO");
    }

    @Override
    public void setParameter(String parameterName, Object parameter) {
    }

    public static boolean isHaveLicense() {
        return isHaveLicense;
    }

    public static String getTumarCspBuild() {
        byte[] result = TumarCspFunctions.cpGetTumarCspBuild();
        String tumarCspBuild = null;
        if (result == null) {
            tumarCspBuild = "0.0.0.0";
        } else {
            tumarCspBuild = new String(result);
            tumarCspBuild = tumarCspBuild.replace(", ", ".");
        }
        return tumarCspBuild;
    }

    static {
        TumarCspFunctions.initialize(LibraryWrapper.LIBRARY_NAME);
    }
}

