/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class JCEECPrivateKey
implements ECPrivateKey {
    private String algorithm = "ECGAMMAKEY";
    private String profile = "";
    private Number hKey = 0;
    private Number hProv = 0;
    private CSPUtil cspUtil = new CSPUtil();

    public JCEECPrivateKey(String prof, Number prov, Number key) {
        this.profile = prof;
        this.hKey = key;
        this.hProv = prov;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.hKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(this.hProv, this.hKey);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hKey = 0;
        try {
            if (this.hProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(this.hProv, 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hProv = 0;
        super.finalize();
    }

    public void setProfile(String prof) {
        this.profile = prof;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setHandleKey(int prov, int key) {
        this.hKey = key;
        this.hProv = prov;
    }

    public Number getHandleKey() {
        return this.hKey;
    }

    public Number getHandleProv() {
        return this.hProv;
    }

    public void closeHandle() {
        if (this.hKey.longValue() != 0L) {
            TumarCspFunctions.cpDestroyKey(this.hProv, this.hKey);
        }
        this.hKey = 0;
        if (this.hProv.longValue() != 0L) {
            TumarCspFunctions.cpReleaseContext(this.hProv, 0);
        }
        this.hProv = 0;
    }

    @Override
    public BigInteger getS() {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return this.profile;
    }

    @Override
    public byte[] getEncoded() {
        return new byte[0];
    }

    @Override
    public ECParameterSpec getParams() {
        return null;
    }

    public int getAlgType() {
        return this.cspUtil.getTypeKey(this.hProv, this.hKey);
    }

    public String toString() {
        return "JCEECPrivateKey{algorithm=" + this.algorithm + ", profile=" + this.profile + ", hKey=" + this.hKey + ", hProv=" + this.hProv + '}';
    }
}

