/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.x509.X509ObjectIdentifiers;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.DSA;
import kz.gamma.crypto.Digest;
import kz.gamma.crypto.digests.GammaGost3411Digest;
import kz.gamma.crypto.params.GammaParameters;
import kz.gamma.crypto.signers.ECGOST3410Signer;
import kz.gamma.jce.exception.CSPException;

public class JDKGOST3410Signer
extends Signature
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSA signer;
    private int hAlgID = 32797;

    protected JDKGOST3410Signer(String name, Digest digest, DSA signer) {
        super(name);
        this.digest = digest;
        this.signer = signer;
    }

    protected JDKGOST3410Signer(String name, Digest digest, DSA signer, int hshAlgID) {
        super(name);
        this.digest = digest;
        this.signer = signer;
        this.hAlgID = hshAlgID;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        GammaParameters param = new GammaParameters(publicKey);
        param.sethashAlgID(this.hAlgID);
        try {
            this.digest.reset();
        }
        catch (CSPException e) {
            throw new InvalidKeyException(e);
        }
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        GammaParameters param = new GammaParameters(privateKey);
        param.sethashAlgID(this.hAlgID);
        this.signer.init(true, param);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        try {
            this.digest.update(b);
        }
        catch (CSPException e) {
            throw new SignatureException(e);
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] sigBytes = null;
        try {
            byte[] hash = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(hash, 0);
            sigBytes = this.signer.generateSignature(hash);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
        return sigBytes;
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        boolean ret = false;
        byte[] hash = new byte[]{};
        byte[] revSign = null;
        hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        ret = this.signer.verifySignature(hash, sigBytes);
        if (!ret && !(ret = this.signer.verifySignature(hash, revSign = UtilCM.inverseCopyByte(sigBytes, 0, sigBytes.length)))) {
            int i;
            revSign = new byte[sigBytes.length];
            for (i = 0; i < sigBytes.length / 2; ++i) {
                revSign[i] = sigBytes[sigBytes.length / 2 - i - 1];
            }
            for (i = 0; i < sigBytes.length / 2; ++i) {
                revSign[i + sigBytes.length / 2] = sigBytes[sigBytes.length - i - 1];
            }
            ret = this.signer.verifySignature(hash, revSign);
            if (!ret) {
                revSign = new byte[sigBytes.length];
                for (i = 0; i < sigBytes.length / 2; ++i) {
                    revSign[i + sigBytes.length / 2] = sigBytes[i];
                }
                for (i = 0; i < sigBytes.length / 2; ++i) {
                    revSign[i] = sigBytes[sigBytes.length / 2 + i];
                }
                ret = this.signer.verifySignature(hash, revSign);
            }
        }
        return ret;
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class gost2012_256
    extends JDKGOST3410Signer {
        public gost2012_256() throws CSPException {
            super("GOST2012256withECGOST3410", new GammaGost3411Digest(32802), new ECGOST3410Signer(), 32802);
        }
    }

    public static class gost2012_512
    extends JDKGOST3410Signer {
        public gost2012_512() throws CSPException {
            super("GOST2012512withECGOST3410", new GammaGost3411Digest(32803), new ECGOST3410Signer(), 32803);
        }
    }

    public static class kzgost34310
    extends JDKGOST3410Signer {
        public kzgost34310() throws CSPException {
            super("KZWITHGOST34310", new GammaGost3411Digest(32797), new ECGOST3410Signer(), 32797);
        }
    }

    public static class cryptopro
    extends JDKGOST3410Signer {
        public cryptopro() throws CSPException {
            super("GOST3411WITHGOST3410-2001", new GammaGost3411Digest(32789), new ECGOST3410Signer(), 32789);
        }
    }

    public static class tumar
    extends JDKGOST3410Signer {
        public tumar() throws CSPException {
            super("TUMARwithECGOST34310", new GammaGost3411Digest(32796), new ECGOST3410Signer(), 32796);
        }
    }

    public static class ecsha256
    extends JDKGOST3410Signer {
        public ecsha256() throws CSPException {
            super("SHA256withRSA", new GammaGost3411Digest(32780), new ECGOST3410Signer(), 32780);
        }
    }

    public static class ecsha1
    extends JDKGOST3410Signer {
        public ecsha1() throws CSPException {
            super("SHA1withRSA", new GammaGost3411Digest(32772), new ECGOST3410Signer(), 32772);
        }
    }

    public static class ecgost34310
    extends JDKGOST3410Signer {
        public ecgost34310() throws CSPException {
            super("GOST3411withECGOST34310", new GammaGost3411Digest(32797), new ECGOST3410Signer());
        }
    }
}

