/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.security.MessageDigest;
import kz.gamma.crypto.Digest;
import kz.gamma.crypto.digests.GammaGost3411Digest;
import kz.gamma.jce.exception.CSPException;

public class JDKMessageDigest
extends MessageDigest {
    Digest digest;

    protected JDKMessageDigest(Digest digest) {
        super(digest.getAlgorithmName());
        this.digest = digest;
    }

    @Override
    public void engineReset() {
        this.digest.reset();
    }

    @Override
    public void engineUpdate(byte input) {
        this.digest.update(input);
    }

    @Override
    public void engineUpdate(byte[] input, int offset, int len) {
        this.digest.update(input, offset, len);
    }

    @Override
    public byte[] engineDigest() {
        byte[] digestBytes = null;
        digestBytes = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(digestBytes, 0);
        return digestBytes;
    }

    public static class CRYPTOPRO
    extends JDKMessageDigest
    implements Cloneable {
        public CRYPTOPRO() throws CSPException {
            super(new GammaGost3411Digest(32789));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            GOST3411 d = (GOST3411)super.clone();
            d.digest = new GammaGost3411Digest((GammaGost3411Digest)this.digest);
            return d;
        }
    }

    public static class TUMAR
    extends JDKMessageDigest
    implements Cloneable {
        public TUMAR() throws CSPException {
            super(new GammaGost3411Digest(32796));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            GOST3411 d = (GOST3411)super.clone();
            d.digest = new GammaGost3411Digest((GammaGost3411Digest)this.digest);
            return d;
        }
    }

    public static class SHA256
    extends JDKMessageDigest
    implements Cloneable {
        public SHA256() throws CSPException {
            super(new GammaGost3411Digest(32780));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            GOST3411 d = (GOST3411)super.clone();
            d.digest = new GammaGost3411Digest((GammaGost3411Digest)this.digest);
            return d;
        }
    }

    public static class SHA1
    extends JDKMessageDigest
    implements Cloneable {
        public SHA1() throws CSPException {
            super(new GammaGost3411Digest(32772));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            GOST3411 d = (GOST3411)super.clone();
            d.digest = new GammaGost3411Digest((GammaGost3411Digest)this.digest);
            return d;
        }
    }

    public static class GOST3411_2012_256
    extends JDKMessageDigest
    implements Cloneable {
        public GOST3411_2012_256() throws CSPException {
            super(new GammaGost3411Digest(32802));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            GOST3411_2012_256 d = new GOST3411_2012_256();
            d.digest = new GammaGost3411Digest((GammaGost3411Digest)this.digest);
            return d;
        }
    }

    public static class GOST3411_2012_512
    extends JDKMessageDigest
    implements Cloneable {
        public GOST3411_2012_512() throws CSPException {
            super(new GammaGost3411Digest(32803));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            GOST3411_2012_512 d = new GOST3411_2012_512();
            d.digest = new GammaGost3411Digest((GammaGost3411Digest)this.digest);
            return d;
        }
    }

    public static class GOST3411
    extends JDKMessageDigest
    implements Cloneable {
        public GOST3411() throws CSPException {
            super(new GammaGost3411Digest(32797));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            GOST3411 d = new GOST3411();
            d.digest = new GammaGost3411Digest((GammaGost3411Digest)this.digest);
            return d;
        }
    }
}

