/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREnumerated;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.BasicConstraints;
import kz.gamma.asn1.x509.GeneralName;
import kz.gamma.asn1.x509.GeneralSubtree;
import kz.gamma.asn1.x509.IssuingDistributionPoint;
import kz.gamma.asn1.x509.NameConstraints;
import kz.gamma.asn1.x509.PolicyInformation;
import kz.gamma.asn1.x509.X509Extensions;
import kz.gamma.jce.provider.AnnotatedException;
import kz.gamma.jce.provider.CertPathValidatorUtilities;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.PKIXNameConstraints;
import kz.gamma.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;
    private static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator _iter;
        HashSet _validPolicyNodeSet;
        PKIXPolicyNode intersection;
        Iterator<PKIXCertPathChecker> tmpIter;
        int tmpInt;
        PKIXPolicyNode node;
        PublicKey workingPublicKey;
        X500Principal workingIssuerName;
        if (!(params instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters paramsPKIX = (PKIXParameters)params;
        if (paramsPKIX.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List<? extends Certificate> certs = certPath.getCertificates();
        int n = certs.size();
        if (certs.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date validDate = CertPathValidatorUtilities.getValidDate(paramsPKIX);
        Set<String> userInitialPolicySet = paramsPKIX.getInitialPolicies();
        TrustAnchor trust = CertPathValidatorUtilities.findTrustAnchor((X509Certificate)certs.get(certs.size() - 1), certPath, certs.size() - 1, paramsPKIX.getTrustAnchors());
        if (trust == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found.", null, certPath, -1);
        }
        int index = 0;
        List[] policyNodes = new ArrayList[n + 1];
        for (int j = 0; j < policyNodes.length; ++j) {
            policyNodes[j] = new ArrayList();
        }
        HashSet<String> policySet = new HashSet<String>();
        policySet.add(ANY_POLICY);
        PKIXPolicyNode validPolicyTree = new PKIXPolicyNode(new ArrayList(), 0, policySet, null, new HashSet(), ANY_POLICY, false);
        policyNodes[0].add(validPolicyTree);
        PKIXNameConstraints nameConstraints = new PKIXNameConstraints();
        HashSet<String> acceptablePolicies = null;
        int explicitPolicy = paramsPKIX.isExplicitPolicyRequired() ? 0 : n + 1;
        int inhibitAnyPolicy = paramsPKIX.isAnyPolicyInhibited() ? 0 : n + 1;
        int policyMapping = paramsPKIX.isPolicyMappingInhibited() ? 0 : n + 1;
        X509Certificate sign = trust.getTrustedCert();
        try {
            if (sign != null) {
                workingIssuerName = CertPathValidatorUtilities.getSubjectPrincipal(sign);
                workingPublicKey = sign.getPublicKey();
            } else {
                workingIssuerName = new X500Principal(trust.getCAName());
                workingPublicKey = trust.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException ex) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + ex.toString());
        }
        AlgorithmIdentifier workingAlgId = CertPathValidatorUtilities.getAlgorithmIdentifier(workingPublicKey);
        DERObjectIdentifier workingPublicKeyAlgorithm = workingAlgId.getObjectId();
        DEREncodable workingPublicKeyParameters = workingAlgId.getParameters();
        int maxPathLength = n;
        if (paramsPKIX.getTargetCertConstraints() != null && !paramsPKIX.getTargetCertConstraints().match((X509Certificate)certs.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        List<PKIXCertPathChecker> pathCheckers = paramsPKIX.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> certIter = pathCheckers.iterator();
        while (certIter.hasNext()) {
            certIter.next().init(false);
        }
        X509Certificate cert = null;
        for (index = certs.size() - 1; index >= 0; --index) {
            try {
                ASN1Sequence certPolicies;
                int i = n - index;
                cert = (X509Certificate)certs.get(index);
                try {
                    cert.verify(workingPublicKey, GammaTechProvider.PROVIDER_NAME);
                }
                catch (GeneralSecurityException e) {
                    throw new CertPathValidatorException("Could not validate certificate signature.", (Throwable)e, certPath, index);
                }
                try {
                    cert.checkValidity(validDate);
                }
                catch (CertificateExpiredException e) {
                    throw new CertPathValidatorException("Could not validate certificate: " + e.getMessage(), (Throwable)e, certPath, index);
                }
                catch (CertificateNotYetValidException e) {
                    throw new CertPathValidatorException("Could not validate certificate: " + e.getMessage(), (Throwable)e, certPath, index);
                }
                if (paramsPKIX.isRevocationEnabled()) {
                    this.checkCRLs(paramsPKIX, cert, validDate, sign, workingPublicKey);
                }
                if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).equals(workingIssuerName)) {
                    throw new CertPathValidatorException("IssuerName(" + CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert) + ") does not match SubjectName(" + workingIssuerName + ") of signing certificate", null, certPath, index);
                }
                if (!CertPathValidatorUtilities.isSelfIssued(cert) || i >= n) {
                    ASN1Sequence dns;
                    X500Principal principal = CertPathValidatorUtilities.getSubjectPrincipal(cert);
                    ASN1InputStream aIn = new ASN1InputStream(principal.getEncoded());
                    try {
                        dns = (ASN1Sequence)aIn.readObject();
                    }
                    catch (IOException e) {
                        throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                    }
                    nameConstraints.checkPermittedDN(dns);
                    nameConstraints.checkExcludedDN(dns);
                    ASN1Sequence altName = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(cert, SUBJECT_ALTERNATIVE_NAME);
                    if (altName != null) {
                        for (int j = 0; j < altName.size(); ++j) {
                            GeneralName name = GeneralName.getInstance(altName.getObjectAt(j));
                            nameConstraints.checkPermitted(name);
                            nameConstraints.checkExcluded(name);
                        }
                    }
                }
                if ((certPolicies = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(cert, CERTIFICATE_POLICIES)) != null && validPolicyTree != null) {
                    PolicyInformation pInfo;
                    Enumeration e = certPolicies.getObjects();
                    HashSet<String> pols = new HashSet<String>();
                    while (e.hasMoreElements()) {
                        Set pq;
                        boolean match;
                        pInfo = PolicyInformation.getInstance(e.nextElement());
                        DERObjectIdentifier pOid = pInfo.getPolicyIdentifier();
                        pols.add(pOid.getId());
                        if (ANY_POLICY.equals(pOid.getId()) || (match = CertPathValidatorUtilities.processCertD1i(i, policyNodes, pOid, pq = CertPathValidatorUtilities.getQualifierSet(pInfo.getPolicyQualifiers())))) continue;
                        CertPathValidatorUtilities.processCertD1ii(i, policyNodes, pOid, pq);
                    }
                    if (acceptablePolicies == null || acceptablePolicies.contains(ANY_POLICY)) {
                        acceptablePolicies = pols;
                    } else {
                        Iterator it = acceptablePolicies.iterator();
                        HashSet t1 = new HashSet();
                        while (it.hasNext()) {
                            Object o = it.next();
                            if (!pols.contains(o)) continue;
                            t1.add(o);
                        }
                        acceptablePolicies = t1;
                    }
                    if (inhibitAnyPolicy > 0 || i < n && CertPathValidatorUtilities.isSelfIssued(cert)) {
                        e = certPolicies.getObjects();
                        while (e.hasMoreElements()) {
                            pInfo = PolicyInformation.getInstance(e.nextElement());
                            if (!ANY_POLICY.equals(pInfo.getPolicyIdentifier().getId())) continue;
                            Set _apq = CertPathValidatorUtilities.getQualifierSet(pInfo.getPolicyQualifiers());
                            List _nodes = policyNodes[i - 1];
                            for (int k = 0; k < _nodes.size(); ++k) {
                                PKIXPolicyNode _node = (PKIXPolicyNode)_nodes.get(k);
                                for (Object _tmp : _node.getExpectedPolicies()) {
                                    String _policy;
                                    if (_tmp instanceof String) {
                                        _policy = (String)_tmp;
                                    } else {
                                        if (!(_tmp instanceof DERObjectIdentifier)) continue;
                                        _policy = ((DERObjectIdentifier)_tmp).getId();
                                    }
                                    boolean _found = false;
                                    Iterator _childrenIter = _node.getChildren();
                                    while (_childrenIter.hasNext()) {
                                        PKIXPolicyNode _child = (PKIXPolicyNode)_childrenIter.next();
                                        if (!_policy.equals(_child.getValidPolicy())) continue;
                                        _found = true;
                                    }
                                    if (_found) continue;
                                    HashSet<String> _newChildExpectedPolicies = new HashSet<String>();
                                    _newChildExpectedPolicies.add(_policy);
                                    PKIXPolicyNode _newChild = new PKIXPolicyNode(new ArrayList(), i, _newChildExpectedPolicies, _node, _apq, _policy, false);
                                    _node.addChild(_newChild);
                                    policyNodes[i].add(_newChild);
                                }
                            }
                        }
                    }
                    for (int j = i - 1; j >= 0; --j) {
                        PKIXPolicyNode node2;
                        List nodes = policyNodes[j];
                        for (int k = 0; k < nodes.size() && ((node2 = (PKIXPolicyNode)nodes.get(k)).hasChildren() || (validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, node2)) != null); ++k) {
                        }
                    }
                    Set<String> criticalExtensionOids = cert.getCriticalExtensionOIDs();
                    if (criticalExtensionOids != null) {
                        boolean critical = criticalExtensionOids.contains(CERTIFICATE_POLICIES);
                        List nodes = policyNodes[i];
                        for (int j = 0; j < nodes.size(); ++j) {
                            node = (PKIXPolicyNode)nodes.get(j);
                            node.setCritical(critical);
                        }
                    }
                }
                if (certPolicies == null) {
                    validPolicyTree = null;
                }
                if (explicitPolicy <= 0 && validPolicyTree == null) {
                    throw new CertPathValidatorException("No valid policy tree found when one expected.");
                }
                if (i != n) {
                    boolean[] _usage;
                    int _plc;
                    BigInteger _pathLengthConstraint;
                    BasicConstraints bc;
                    int _inhibitAnyPolicy;
                    DERInteger iap;
                    ASN1Sequence pc;
                    ASN1Sequence ncSeq;
                    ASN1Sequence mappings;
                    if (cert != null && cert.getVersion() == 1) {
                        throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                    }
                    DERObject pm = CertPathValidatorUtilities.getExtensionValue(cert, POLICY_MAPPINGS);
                    if (pm != null) {
                        mappings = (ASN1Sequence)pm;
                        for (int j = 0; j < mappings.size(); ++j) {
                            ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j);
                            DERObjectIdentifier issuerDomainPolicy = (DERObjectIdentifier)mapping.getObjectAt(0);
                            DERObjectIdentifier subjectDomainPolicy = (DERObjectIdentifier)mapping.getObjectAt(1);
                            if (ANY_POLICY.equals(issuerDomainPolicy.getId())) {
                                throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                            }
                            if (!ANY_POLICY.equals(subjectDomainPolicy.getId())) continue;
                            throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                        }
                    }
                    if (pm != null) {
                        mappings = (ASN1Sequence)pm;
                        HashMap m_idp = new HashMap();
                        HashSet<String> s_idp = new HashSet<String>();
                        for (int j = 0; j < mappings.size(); ++j) {
                            Set<String> tmp;
                            ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j);
                            String id_p = ((DERObjectIdentifier)mapping.getObjectAt(0)).getId();
                            String sd_p = ((DERObjectIdentifier)mapping.getObjectAt(1)).getId();
                            if (!m_idp.containsKey(id_p)) {
                                tmp = new HashSet<String>();
                                tmp.add(sd_p);
                                m_idp.put(id_p, tmp);
                                s_idp.add(id_p);
                                continue;
                            }
                            tmp = (Set)m_idp.get(id_p);
                            tmp.add(sd_p);
                        }
                        block41: for (String id_p : s_idp) {
                            if (policyMapping > 0) {
                                boolean idp_found = false;
                                for (PKIXPolicyNode node3 : policyNodes[i]) {
                                    if (!node3.getValidPolicy().equals(id_p)) continue;
                                    idp_found = true;
                                    node3.expectedPolicies = (Set)m_idp.get(id_p);
                                    break;
                                }
                                if (idp_found) continue;
                                for (PKIXPolicyNode node3 : policyNodes[i]) {
                                    PKIXPolicyNode p_node;
                                    if (!ANY_POLICY.equals(node3.getValidPolicy())) continue;
                                    Set pq = null;
                                    ASN1Sequence policies = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(cert, CERTIFICATE_POLICIES);
                                    Enumeration e = policies.getObjects();
                                    while (e.hasMoreElements()) {
                                        PolicyInformation pinfo = PolicyInformation.getInstance(e.nextElement());
                                        if (!ANY_POLICY.equals(pinfo.getPolicyIdentifier().getId())) continue;
                                        pq = CertPathValidatorUtilities.getQualifierSet(pinfo.getPolicyQualifiers());
                                        break;
                                    }
                                    boolean ci = false;
                                    if (cert.getCriticalExtensionOIDs() != null) {
                                        ci = cert.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                                    }
                                    if (!ANY_POLICY.equals((p_node = (PKIXPolicyNode)node3.getParent()).getValidPolicy())) continue block41;
                                    PKIXPolicyNode c_node = new PKIXPolicyNode(new ArrayList(), i, (Set)m_idp.get(id_p), p_node, pq, id_p, ci);
                                    p_node.addChild(c_node);
                                    policyNodes[i].add(c_node);
                                    continue block41;
                                }
                                continue;
                            }
                            if (policyMapping > 0) continue;
                            Iterator nodes_i = policyNodes[i].iterator();
                            while (nodes_i.hasNext()) {
                                PKIXPolicyNode node4 = (PKIXPolicyNode)nodes_i.next();
                                if (!node4.getValidPolicy().equals(id_p)) continue;
                                PKIXPolicyNode p_node = (PKIXPolicyNode)node4.getParent();
                                p_node.removeChild(node4);
                                nodes_i.remove();
                                for (int k = i - 1; k >= 0; --k) {
                                    PKIXPolicyNode node2;
                                    List nodes = policyNodes[k];
                                    for (int l = 0; l < nodes.size() && ((node2 = (PKIXPolicyNode)nodes.get(l)).hasChildren() || (validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, node2)) != null); ++l) {
                                    }
                                }
                            }
                        }
                    }
                    if ((ncSeq = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(cert, NAME_CONSTRAINTS)) != null) {
                        ASN1Sequence excluded;
                        NameConstraints nc = new NameConstraints(ncSeq);
                        ASN1Sequence permitted = nc.getPermittedSubtrees();
                        if (permitted != null) {
                            Enumeration e = permitted.getObjects();
                            while (e.hasMoreElements()) {
                                GeneralSubtree subtree = GeneralSubtree.getInstance(e.nextElement());
                                nameConstraints.intersectPermittedSubtree(subtree);
                            }
                        }
                        if ((excluded = nc.getExcludedSubtrees()) != null) {
                            Enumeration e = excluded.getObjects();
                            while (e.hasMoreElements()) {
                                GeneralSubtree subtree = GeneralSubtree.getInstance(e.nextElement());
                                nameConstraints.addExcludedSubtree(subtree);
                            }
                        }
                    }
                    if (!CertPathValidatorUtilities.isSelfIssued(cert)) {
                        if (explicitPolicy != 0) {
                            --explicitPolicy;
                        }
                        if (policyMapping != 0) {
                            --policyMapping;
                        }
                        if (inhibitAnyPolicy != 0) {
                            --inhibitAnyPolicy;
                        }
                    }
                    if ((pc = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(cert, POLICY_CONSTRAINTS)) != null) {
                        Enumeration policyConstraints = pc.getObjects();
                        while (policyConstraints.hasMoreElements()) {
                            ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                            switch (constraint.getTagNo()) {
                                case 0: {
                                    tmpInt = DERInteger.getInstance(constraint).getValue().intValue();
                                    if (tmpInt >= explicitPolicy) break;
                                    explicitPolicy = tmpInt;
                                    break;
                                }
                                case 1: {
                                    tmpInt = DERInteger.getInstance(constraint).getValue().intValue();
                                    if (tmpInt >= policyMapping) break;
                                    policyMapping = tmpInt;
                                }
                            }
                        }
                    }
                    if ((iap = (DERInteger)CertPathValidatorUtilities.getExtensionValue(cert, INHIBIT_ANY_POLICY)) != null && (_inhibitAnyPolicy = iap.getValue().intValue()) < inhibitAnyPolicy) {
                        inhibitAnyPolicy = _inhibitAnyPolicy;
                    }
                    if ((bc = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, BASIC_CONSTRAINTS))) != null) {
                        if (!bc.isCA()) {
                            throw new CertPathValidatorException("Not a CA certificate");
                        }
                    } else {
                        throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                    }
                    if (!CertPathValidatorUtilities.isSelfIssued(cert)) {
                        if (maxPathLength <= 0) {
                            throw new CertPathValidatorException("Max path length not greater than zero");
                        }
                        --maxPathLength;
                    }
                    if (bc != null && (_pathLengthConstraint = bc.getPathLenConstraint()) != null && (_plc = _pathLengthConstraint.intValue()) < maxPathLength) {
                        maxPathLength = _plc;
                    }
                    if ((_usage = cert.getKeyUsage()) != null && !_usage[5]) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, index);
                    }
                    HashSet<String> criticalExtensions = new HashSet<String>(cert.getCriticalExtensionOIDs());
                    criticalExtensions.remove(KEY_USAGE);
                    criticalExtensions.remove(CERTIFICATE_POLICIES);
                    criticalExtensions.remove(POLICY_MAPPINGS);
                    criticalExtensions.remove(INHIBIT_ANY_POLICY);
                    criticalExtensions.remove(ISSUING_DISTRIBUTION_POINT);
                    criticalExtensions.remove(DELTA_CRL_INDICATOR);
                    criticalExtensions.remove(POLICY_CONSTRAINTS);
                    criticalExtensions.remove(BASIC_CONSTRAINTS);
                    criticalExtensions.remove(SUBJECT_ALTERNATIVE_NAME);
                    criticalExtensions.remove(NAME_CONSTRAINTS);
                    tmpIter = pathCheckers.iterator();
                    while (tmpIter.hasNext()) {
                        try {
                            tmpIter.next().check(cert, criticalExtensions);
                        }
                        catch (CertPathValidatorException e) {
                            throw new CertPathValidatorException(e.getMessage(), e.getCause(), certPath, index);
                        }
                    }
                    if (!criticalExtensions.isEmpty()) {
                        throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, index);
                    }
                }
                sign = cert;
                workingPublicKey = CertPathValidatorUtilities.getNextWorkingKey(sign, certs, index);
                try {
                    workingIssuerName = CertPathValidatorUtilities.getSubjectPrincipal(sign);
                }
                catch (IllegalArgumentException ex) {
                    throw new CertPathValidatorException(sign.getSubjectDN().getName() + " :" + ex.toString());
                }
                workingAlgId = CertPathValidatorUtilities.getAlgorithmIdentifier(workingPublicKey);
                workingPublicKeyAlgorithm = workingAlgId.getObjectId();
                workingPublicKeyParameters = workingAlgId.getParameters();
                continue;
            }
            catch (AnnotatedException e) {
                throw new CertPathValidatorException(e.getMessage(), e.getUnderlyingException(), certPath, index);
            }
        }
        if (!CertPathValidatorUtilities.isSelfIssued(cert) && explicitPolicy != 0) {
            --explicitPolicy;
        }
        try {
            ASN1Sequence pc = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(cert, POLICY_CONSTRAINTS);
            if (pc != null) {
                Enumeration policyConstraints = pc.getObjects();
                while (policyConstraints.hasMoreElements()) {
                    ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                    switch (constraint.getTagNo()) {
                        case 0: {
                            tmpInt = DERInteger.getInstance(constraint).getValue().intValue();
                            if (tmpInt != 0) break;
                            explicitPolicy = 0;
                        }
                    }
                }
            }
        }
        catch (AnnotatedException e) {
            throw new CertPathValidatorException(e.getMessage(), e.getUnderlyingException(), certPath, index);
        }
        Set<String> criticalExtensions = cert.getCriticalExtensionOIDs();
        if (criticalExtensions != null) {
            criticalExtensions = new HashSet<String>(criticalExtensions);
            criticalExtensions.remove(KEY_USAGE);
            criticalExtensions.remove(CERTIFICATE_POLICIES);
            criticalExtensions.remove(POLICY_MAPPINGS);
            criticalExtensions.remove(INHIBIT_ANY_POLICY);
            criticalExtensions.remove(ISSUING_DISTRIBUTION_POINT);
            criticalExtensions.remove(DELTA_CRL_INDICATOR);
            criticalExtensions.remove(POLICY_CONSTRAINTS);
            criticalExtensions.remove(BASIC_CONSTRAINTS);
            criticalExtensions.remove(SUBJECT_ALTERNATIVE_NAME);
            criticalExtensions.remove(NAME_CONSTRAINTS);
        } else {
            criticalExtensions = new HashSet<String>();
        }
        tmpIter = pathCheckers.iterator();
        while (tmpIter.hasNext()) {
            try {
                tmpIter.next().check(cert, criticalExtensions);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathValidatorException(e.getMessage(), e.getCause(), certPath, index);
            }
        }
        if (!criticalExtensions.isEmpty()) {
            throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, index);
        }
        if (validPolicyTree == null) {
            if (paramsPKIX.isExplicitPolicyRequired()) {
                throw new CertPathValidatorException("Explicit policy requested but none available.");
            }
            intersection = null;
        } else if (CertPathValidatorUtilities.isAnyPolicy(userInitialPolicySet)) {
            if (paramsPKIX.isExplicitPolicyRequired()) {
                if (acceptablePolicies.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none available.");
                }
                _validPolicyNodeSet = new HashSet();
                for (int j = 0; j < policyNodes.length; ++j) {
                    ArrayList _nodeDepth = policyNodes[j];
                    for (int k = 0; k < _nodeDepth.size(); ++k) {
                        PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k);
                        if (!ANY_POLICY.equals(_node.getValidPolicy())) continue;
                        _iter = _node.getChildren();
                        while (_iter.hasNext()) {
                            _validPolicyNodeSet.add(_iter.next());
                        }
                    }
                }
                for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                    String _validPolicy = _node.getValidPolicy();
                    if (acceptablePolicies.contains(_validPolicy)) continue;
                }
                if (validPolicyTree != null) {
                    for (int j = n - 1; j >= 0; --j) {
                        List nodes = policyNodes[j];
                        for (int k = 0; k < nodes.size(); ++k) {
                            node = (PKIXPolicyNode)nodes.get(k);
                            if (node.hasChildren()) continue;
                            validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, node);
                        }
                    }
                }
            }
            intersection = validPolicyTree;
        } else {
            _validPolicyNodeSet = new HashSet();
            for (int j = 0; j < policyNodes.length; ++j) {
                ArrayList _nodeDepth = policyNodes[j];
                for (int k = 0; k < _nodeDepth.size(); ++k) {
                    PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k);
                    if (!ANY_POLICY.equals(_node.getValidPolicy())) continue;
                    _iter = _node.getChildren();
                    while (_iter.hasNext()) {
                        PKIXPolicyNode _c_node = (PKIXPolicyNode)_iter.next();
                        if (ANY_POLICY.equals(_c_node.getValidPolicy())) continue;
                        _validPolicyNodeSet.add(_c_node);
                    }
                }
            }
            for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                String _validPolicy = _node.getValidPolicy();
                if (userInitialPolicySet.contains(_validPolicy)) continue;
                validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, _node);
            }
            if (validPolicyTree != null) {
                for (int j = n - 1; j >= 0; --j) {
                    ArrayList nodes = policyNodes[j];
                    for (int k = 0; k < nodes.size(); ++k) {
                        node = (PKIXPolicyNode)nodes.get(k);
                        if (node.hasChildren()) continue;
                        validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, node);
                    }
                }
            }
            intersection = validPolicyTree;
        }
        if (explicitPolicy > 0 || intersection != null) {
            return new PKIXCertPathValidatorResult(trust, intersection, workingPublicKey);
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, index);
    }

    private void checkCRLs(PKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey) throws AnnotatedException {
        X509CRLSelector crlselect = new X509CRLSelector();
        try {
            crlselect.addIssuerName(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).getEncoded());
        }
        catch (IOException e) {
            throw new AnnotatedException("Cannot extract issuer from certificate: " + e, e);
        }
        crlselect.setCertificateChecking(cert);
        Iterator crl_iter = CertPathValidatorUtilities.findCRLs(crlselect, paramsPKIX.getCertStores()).iterator();
        boolean validCrlFound = false;
        while (crl_iter.hasNext()) {
            boolean[] keyusage;
            X509CRL crl = (X509CRL)crl_iter.next();
            if (!cert.getNotAfter().after(crl.getThisUpdate())) continue;
            if (crl.getNextUpdate() == null || validDate.before(crl.getNextUpdate())) {
                validCrlFound = true;
            }
            if (!(sign == null || (keyusage = sign.getKeyUsage()) == null || keyusage.length >= 7 && keyusage[6])) {
                throw new AnnotatedException("Issuer certificate keyusage extension does not permit crl signing.\n" + sign);
            }
            try {
                crl.verify(workingPublicKey, GammaTechProvider.PROVIDER_NAME);
            }
            catch (Exception e) {
                throw new AnnotatedException("can't verify CRL: " + e, e);
            }
            X509CRLEntry crl_entry = crl.getRevokedCertificate(cert.getSerialNumber());
            if (crl_entry != null && !validDate.before(crl_entry.getRevocationDate())) {
                DEREnumerated reasonCode;
                String reason = null;
                if (crl_entry.hasExtensions() && (reasonCode = DEREnumerated.getInstance(CertPathValidatorUtilities.getExtensionValue(crl_entry, X509Extensions.ReasonCode.getId()))) != null) {
                    reason = crlReasons[reasonCode.getValue().intValue()];
                }
                String message = "Certificate revocation after " + crl_entry.getRevocationDate();
                if (reason != null) {
                    message = message + ", reason: " + reason;
                }
                throw new AnnotatedException(message);
            }
            DERObject idp = CertPathValidatorUtilities.getExtensionValue(crl, ISSUING_DISTRIBUTION_POINT);
            DERObject dci = CertPathValidatorUtilities.getExtensionValue(crl, DELTA_CRL_INDICATOR);
            if (dci != null) {
                X509CRLSelector baseSelect = new X509CRLSelector();
                try {
                    baseSelect.addIssuerName(CertPathValidatorUtilities.getIssuerPrincipal(crl).getEncoded());
                }
                catch (IOException e) {
                    throw new AnnotatedException("can't extract issuer from certificate: " + e, e);
                }
                baseSelect.setMinCRLNumber(((DERInteger)dci).getPositiveValue());
                baseSelect.setMaxCRLNumber(((DERInteger)CertPathValidatorUtilities.getExtensionValue(crl, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                boolean foundBase = false;
                for (X509CRL base : CertPathValidatorUtilities.findCRLs(baseSelect, paramsPKIX.getCertStores())) {
                    DERObject baseIdp = CertPathValidatorUtilities.getExtensionValue(base, ISSUING_DISTRIBUTION_POINT);
                    if (idp == null) {
                        if (baseIdp != null) continue;
                        foundBase = true;
                        break;
                    }
                    if (!idp.equals(baseIdp)) continue;
                    foundBase = true;
                    break;
                }
                if (!foundBase) {
                    throw new AnnotatedException("No base CRL for delta CRL");
                }
            }
            if (idp == null) continue;
            IssuingDistributionPoint p = IssuingDistributionPoint.getInstance(idp);
            BasicConstraints bc = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue(cert, BASIC_CONSTRAINTS));
            if (p.onlyContainsUserCerts() && bc != null && bc.isCA()) {
                throw new AnnotatedException("CA Cert CRL only contains user certificates");
            }
            if (p.onlyContainsCACerts() && (bc == null || !bc.isCA())) {
                throw new AnnotatedException("End CRL only contains CA certificates");
            }
            if (!p.onlyContainsAttributeCerts()) continue;
            throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted");
        }
        if (!validCrlFound) {
            throw new AnnotatedException("no valid CRL found");
        }
    }
}

