/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import kz.gamma.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class AlgParamUtil {
    public Hashtable<String, Integer> algKey = new Hashtable();
    public Hashtable<String, String> algKeyName = new Hashtable();
    private Hashtable<Integer, Integer> algIdAlgCode = new Hashtable();
    private Boolean isCspContainsKzOids = false;
    private static final Integer[] ALL_ALGORITHM_CODES = new Integer[]{3, 4, 7, 8, 15, 16, 17, 21, 21, 22, 22, 23, 23, 27, 28, 30, 41, 42, 43, 44, 45, 10, 12, 13, 24, 25, 33, 31, 32, 51, 52, 53, 54, 55};
    private static final Integer[] ALL_ALGORITHM_IDENTIFIERS = new Integer[]{43570, 43571, 43574, 43553, 43582, 43583, 43593, 43578, 10810, 43584, 10816, 43585, 10817, 43579, 43580, 43581, 42064, 42065, 42066, 42067, 42068, 41026, 41028, 41035, 41029, 41030, 41033, 41031, 41032, 41040, 41041, 41042, 41043, 41044};
    private static final List<Integer> ALL_ALGORITHM_CODES_LIST = Arrays.asList(ALL_ALGORITHM_CODES);
    private static final List<Integer> ALL_ALGORITHM_IDENTIFIERS_LIST = Arrays.asList(ALL_ALGORITHM_IDENTIFIERS);

    public AlgParamUtil() {
        this.setKey();
    }

    @Deprecated
    public int getSize(byte[] data, int offset) {
        return DataConverter.getSizeWithoutNulls(data, offset);
    }

    public String getOID(int algId) {
        String oid = "";
        for (Map.Entry<String, Integer> entry : this.algKey.entrySet()) {
            if (!entry.getValue().equals(algId)) continue;
            oid = entry.getKey();
            break;
        }
        return oid;
    }

    public Integer getAlgCode(int algId) {
        for (Map.Entry<Integer, Integer> entry : this.algIdAlgCode.entrySet()) {
            if (!entry.getKey().equals(algId)) continue;
            return entry.getValue();
        }
        throw new RuntimeException("AlgId not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getAttribute(int param, int field) {
        Number hProvLocal = 0;
        try {
            hProvLocal = TumarCspFunctions.cpAcquireContext("", -268435456, LibraryWrapper.PV_TABLE);
            ArrayList<byte[]> ret = new ArrayList<byte[]>();
            byte[] data = null;
            int dwFlags = 1;
            do {
                if ((data = TumarCspFunctions.cpGetProvParamByte(hProvLocal, field, dwFlags, param)) == null) continue;
                dwFlags = 0;
                ret.add(data);
            } while (data != null);
            ArrayList<byte[]> arrayList = ret;
            return arrayList;
        }
        finally {
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
        }
    }

    public void setKey() {
        int i;
        List<byte[]> algCode = this.getAttribute(0, 52);
        List<byte[]> algID = this.getAttribute(1, 52);
        List<byte[]> oid = this.getAttribute(4, 52);
        List<byte[]> name = this.getAttribute(5, 52);
        List<byte[]> algCodeEX = this.getAttribute(0, 51);
        List<byte[]> algIDEX = this.getAttribute(1, 51);
        List<byte[]> oidEX = this.getAttribute(4, 51);
        List<byte[]> nameEX = this.getAttribute(5, 51);
        for (i = 0; i < oid.size(); ++i) {
            String oidString = new String(oid.get(i));
            if (oidString.contains(KZObjectIndentifiers.KZ_id.getId())) {
                this.isCspContainsKzOids = true;
            }
            this.algKey.put(oidString, UtilCM.byteToInt(algID.get(i), 0, 1));
            this.algKeyName.put(new String(name.get(i)), oidString);
            this.algIdAlgCode.put(UtilCM.byteToInt(algID.get(i), 0, 1), UtilCM.byteToInt(algCode.get(i), 0, 1));
        }
        for (i = 0; i < oidEX.size(); ++i) {
            String oidEXString = new String(oidEX.get(i));
            if (oidEXString.contains(KZObjectIndentifiers.KZ_id.getId())) {
                this.isCspContainsKzOids = true;
            }
            this.algKey.put(oidEXString, UtilCM.byteToInt(algIDEX.get(i), 0, 1));
            this.algKeyName.put(new String(nameEX.get(i)), oidEXString);
            this.algIdAlgCode.put(UtilCM.byteToInt(algIDEX.get(i), 0, 1), UtilCM.byteToInt(algCodeEX.get(i), 0, 1));
        }
    }

    public Hashtable<String, Integer> getAlgKey() {
        return this.algKey;
    }

    public Hashtable<String, String> getAlgKeyName() {
        return this.algKeyName;
    }

    public Hashtable<Integer, Integer> getAlgIdAlgCode() {
        return this.algIdAlgCode;
    }

    public Boolean isAlgCode(Integer number) {
        return ALL_ALGORITHM_CODES_LIST.contains(number);
    }

    public Boolean isAlgId(Integer number) {
        return ALL_ALGORITHM_IDENTIFIERS_LIST.contains(number);
    }

    public Boolean isCspContainsKzOids() {
        return this.isCspContainsKzOids;
    }

    public Integer getAlgId(int algCode) {
        Integer algId = 0;
        Integer entriesFound = 0;
        if (this.isAlgCode(algCode).booleanValue()) {
            for (Map.Entry<Integer, Integer> entry : this.algIdAlgCode.entrySet()) {
                if (!entry.getValue().equals(algCode)) continue;
                algId = entry.getKey();
                Integer n = entriesFound;
                Integer n2 = entriesFound = Integer.valueOf(entriesFound + 1);
            }
            String message = null;
            if (entriesFound == 0 || algId == 0) {
                message = String.format("Alg id not found for alg code \"%d\"", algCode);
                throw new RuntimeException(message);
            }
            if (entriesFound > 1) {
                message = String.format("Collision occured. %d entries found for alg code \"%d\"", entriesFound, algCode);
                throw new RuntimeException(message);
            }
        } else {
            String message = String.format("Unknown algorithm code: %d", algCode);
            throw new RuntimeException(message);
        }
        return algId;
    }
}

