/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp.params;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Date;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.KeyParams;

public class StoreObjectParam {
    @Deprecated
    public Date timeCreate;
    @Deprecated
    public String oid;
    @Deprecated
    public String sn;
    private String pubKey;
    private X509Certificate x509certificate;
    private Integer keyState;
    private Integer keyExpState;
    private Integer keyAlg;
    private X509Certificate caX509certificate;
    private Key privateKey;
    @Deprecated
    public String dn;
    @Deprecated
    public String profile;

    public StoreObjectParam(String dn, String oid, String sn, String profile, Date timDate) {
        this.timeCreate = timDate;
        this.oid = oid;
        this.sn = sn;
        this.pubKey = null;
        this.x509certificate = null;
        this.keyState = null;
        this.keyExpState = null;
        this.keyAlg = null;
        this.dn = dn;
        this.profile = profile;
        this.caX509certificate = null;
        this.privateKey = null;
    }

    public StoreObjectParam(String profile, KeyParams keyParams, Integer index) {
        this.timeCreate = (Date)keyParams.getCreateTimeList()[index];
        this.oid = (String)keyParams.getSzOIDList()[index];
        this.sn = (String)keyParams.getSerialNumList()[index];
        this.pubKey = (String)keyParams.getPublicKeyList()[index];
        this.x509certificate = (X509Certificate)keyParams.getCertificateList()[index];
        this.keyState = (Integer)keyParams.getKeyStateList()[index];
        this.keyExpState = (Integer)keyParams.getKeyExpStateList()[index];
        this.keyAlg = (Integer)keyParams.getKeyAlgIDList()[index];
        this.timeCreate = (Date)keyParams.getCreateTimeList()[index];
        this.dn = null;
        if (this.x509certificate != null) {
            this.dn = this.x509certificate.getSubjectDN().getName();
            this.timeCreate = this.x509certificate.getNotBefore();
        }
        this.profile = profile;
        this.caX509certificate = (X509Certificate)keyParams.getCaCertificateList()[index];
        this.privateKey = (Key)keyParams.getPrivateKeyList()[index];
    }

    public String getFullProfile() {
        return UtilCM.getUrl(this.profile, this.sn, 1);
    }

    public String getFullProfile(String pass) {
        String fullProfile = UtilCM.getUrl(this.profile, pass, 0);
        fullProfile = UtilCM.getUrl(fullProfile, this.sn, 1);
        return fullProfile;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.profile).append(",  ").append(this.dn).append(",  ").append(this.sn).append(",  ").append(this.oid).append(",  ").append(this.timeCreate).append(",  ").append(this.pubKey).append(",  ").append(this.x509certificate).append(",  ").append(this.keyState).append(",  ").append(this.keyExpState).append(",  ").append(this.keyAlg).append(",  ").append(this.caX509certificate).append(",  ").append(this.privateKey);
        return stringBuffer.toString();
    }

    public Date getTimeCreate() {
        return this.timeCreate;
    }

    public String getOid() {
        return this.oid;
    }

    public String getSn() {
        return this.sn;
    }

    public String getPubKey() {
        return this.pubKey;
    }

    public X509Certificate getX509certificate() {
        return this.x509certificate;
    }

    public Integer getKeyState() {
        return this.keyState;
    }

    public Integer getKeyExpState() {
        return this.keyExpState;
    }

    public Integer getKeyAlg() {
        return this.keyAlg;
    }

    public String getDn() {
        return this.dn;
    }

    public String getProfile() {
        return this.profile;
    }

    public X509Certificate getCaX509certificate() {
        return this.caX509certificate;
    }

    public Key getPrivateKey() {
        return this.privateKey;
    }
}

