/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.vista.sftp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.cms.Attribute;
import kz.gamma.asn1.cms.AttributeTable;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.cms.CMSProcessableByteArray;
import kz.gamma.cms.CMSSignedData;
import kz.gamma.cms.CMSSignedDataGenerator;
import kz.gamma.cms.CMSVistaSignedDataGenerator;
import kz.gamma.core.UtilCM;
import kz.gamma.hash.GOST3411Digest;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.JCEECPrivateKey;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.params.StoreObjectParam;
import kz.gamma.util.encoders.Base64;
import kz.gamma.vista.sftp.SFTPException;
import kz.gamma.vista.sftp.SFTPNode;
import kz.gamma.vista.sftp.Tokenizer;

public class SFTPConnector {
    private JCEECPrivateKey userSignKey = null;
    private JCEECPrivateKey userExchKey = null;
    private X509Certificate userSignCert = null;
    private X509Certificate userExchCert = null;
    private String addrServer = "";
    private int port = 62200;
    private byte[] buf = new byte[4096];
    private final Socket sock = new Socket();
    private InputStream bi = null;
    private OutputStream bo = null;
    private String dnServer = "";
    private String serverExchSN = "";
    private String serverSignSN = "";
    private X509Certificate serverExchCert = null;
    private X509Certificate serverSignCert = null;
    private Number hSesKey = 0;
    private Number hHashRc = 0;
    private Number hHashVr = 0;

    public SFTPConnector(PrivateKey userSignKey, PrivateKey userExchKey, X509Certificate userSignCert, X509Certificate userExchCert, String addr, int port) {
        this.userSignKey = (JCEECPrivateKey)userSignKey;
        this.userExchKey = (JCEECPrivateKey)userExchKey;
        this.userSignCert = userSignCert;
        this.userExchCert = userExchCert;
        this.addrServer = addr;
        this.port = port;
    }

    public SFTPConnector(PrivateKey userSignKey, PrivateKey userExchKey, X509Certificate userSignCert, X509Certificate userExchCert, String addr) {
        this(userSignKey, userExchKey, userSignCert, userExchCert, addr, 62200);
    }

    public SFTPConnector(KeyStore store, String addr, int port) throws KeyStoreException {
        this.addrServer = addr;
        this.port = port;
        Enumeration<String> en = store.aliases();
        while (en.hasMoreElements()) {
            StoreObjectParam prm = (StoreObjectParam)((Object)en.nextElement());
            System.out.println(prm.getOid());
            X509Certificate tmp = prm.getX509certificate();
            if (tmp == null) continue;
            if (prm.getOid().equals("1.3.6.1.4.1.6801.1.8.8")) {
                if (this.userExchCert == null) {
                    this.userExchCert = tmp;
                    this.userExchKey = (JCEECPrivateKey)prm.getPrivateKey();
                } else if (tmp.getNotAfter().after(this.userExchCert.getNotAfter())) {
                    this.userExchCert = tmp;
                    this.userExchKey = (JCEECPrivateKey)prm.getPrivateKey();
                }
            }
            if (!prm.getOid().equals("1.3.6.1.4.1.6801.1.5.8")) continue;
            if (this.userSignCert == null) {
                this.userSignCert = tmp;
                this.userSignKey = (JCEECPrivateKey)prm.getPrivateKey();
                continue;
            }
            if (!tmp.getNotAfter().after(this.userSignCert.getNotAfter())) continue;
            this.userSignCert = tmp;
            this.userSignKey = (JCEECPrivateKey)prm.getPrivateKey();
        }
    }

    public SFTPConnector(KeyStore store, String addr) throws KeyStoreException {
        this(store, addr, 62200);
    }

    public void init(String ldapURL, Integer stout) {
        int timeout = 1000;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (stout < 60 || stout > 3600) {
                throw new SFTPException("Timeout not range");
            }
            InetAddress addr = this.createInetAddress(this.addrServer);
            this.sock.connect(new InetSocketAddress(addr, 62200), timeout);
            this.sock.setSoTimeout(0);
            this.bi = this.sock.getInputStream();
            this.bo = this.sock.getOutputStream();
            String tmp = this.readLineRN(false);
            if (!tmp.contains("Vnode")) {
                throw new SFTPException("Server [" + addr + "] return: " + tmp);
            }
            stringBuilder.append(this.userExchCert.getSubjectDN().getName().replaceAll(",", ";"));
            stringBuilder.append("# OS=[android] LT=[30/07/2013 10:32:44] APP=[4.0.33.220] LIB=[1.0.0.7] CSP=[5, 2, 696, 545]");
            this.sendCommand("USER", stringBuilder.toString(), false);
            this.dnServer = this.readLineRN(false).substring(1);
            stringBuilder.setLength(0);
            stringBuilder.append(new String(Base64.encode(this.userExchCert.getSerialNumber().toByteArray())));
            stringBuilder.append("-");
            stringBuilder.append(new String(Base64.encode(this.userSignCert.getSerialNumber().toByteArray())));
            this.sendCommand("PASS", stringBuilder.toString(), false);
            stringBuilder.setLength(0);
            String str = this.readLineRN(false);
            int size = (str.length() - 3) / 2;
            this.serverExchSN = UtilCM.array2hex(Base64.decode(UtilCM.copyByte(this.buf, 2, size)));
            this.serverSignSN = UtilCM.array2hex(Base64.decode(UtilCM.copyByte(this.buf, 3 + size, size)));
            this.serverExchCert = this.getCertificate(this.dnServer, this.serverExchSN, ldapURL);
            this.serverSignCert = this.getCertificate(this.dnServer, this.serverSignSN, ldapURL);
            byte[] simpleBlob = this.expSesKey(this.serverExchCert);
            this.sendCommand("ACCT", new String(Base64.encode(simpleBlob)), false);
            str = this.readLineRN(false).substring(1);
            this.ImpSessKey(Base64.decode(str.getBytes()), this.serverExchCert);
            this.sendCommand("SITE IDLE", stout.toString(), true);
            this.readLineRN(true);
        }
        catch (IOException e) {
            throw new SFTPException(e);
        }
    }

    public void disconnect() {
        try {
            this.sendCommand("DONE", "0", true);
            this.readLineRN(true);
        }
        catch (IOException e) {
            throw new SFTPException(e);
        }
    }

    public boolean changeDir(String dirName) {
        boolean ret = true;
        try {
            if (dirName == null) {
                dirName = "dwn";
            }
            this.sendCommand("CDIR", dirName, true);
            String str = this.readLineRN(true);
            if (str.charAt(0) == '-') {
                ret = false;
            }
        }
        catch (IOException e) {
            throw new SFTPException(e);
        }
        return ret;
    }

    public ArrayList<SFTPNode> listDir(int flag) {
        String str = "";
        ArrayList<SFTPNode> sftpNodes = new ArrayList<SFTPNode>();
        try {
            switch (flag) {
                case 3: {
                    this.sendCommand("LIST P", ".", true);
                    str = this.readLineRN(false);
                    if (str.charAt(0) != '-') break;
                    this.checkAuthMessForSend(str);
                    this.sendCommand("LIST V", ".", true);
                    str = this.readLineRN(false);
                    break;
                }
                case 1: {
                    this.sendCommand("LIST V", ".", true);
                    str = this.readLineRN(false);
                }
            }
            str = str.substring(1, str.indexOf(32));
            int count = new Integer(str);
            for (int i = 0; i < count; ++i) {
                String fName = this.readLineRN(false);
                SFTPNode sftpNode = new SFTPNode(fName);
                sftpNodes.add(sftpNode);
            }
        }
        catch (IOException e) {
            throw new SFTPException(e);
        }
        return sftpNodes;
    }

    public byte[] readNode(String fileName) {
        byte[] ret = null;
        try {
            this.sendCommand("RETR", fileName, true);
            String str = this.readLineRN(true);
            Integer size = new Integer(str.substring(1, str.indexOf(91) - 1));
            ret = new byte[size.intValue()];
            this.sendCommand("SEND", size.toString(), true);
            this.readBlock(ret);
        }
        catch (IOException e) {
            throw new SFTPException(e);
        }
        return ret;
    }

    public void createFile(String fileName, byte[] data, int attr) {
        try {
            String str;
            if ((attr & 1) != 0 && (attr & 0x100) != 0) {
                this.sendCommand("STOR NEW", fileName, true);
                str = this.readLineRN(true);
            } else if ((attr & 1) != 0 && (attr & 0x200) != 0) {
                this.sendCommand("STOR OLD", fileName, true);
                str = this.readLineRN(true);
            } else if ((attr & 1) != 0 && (attr & 0x800) != 0) {
                this.sendCommand("STOR APP", fileName, true);
                str = this.readLineRN(true);
            }
            if ((attr & 1) != 0) {
                Integer size = new Integer(data.length);
                this.sendCommand("SIZE", size.toString(), true);
                str = this.readLineRN(true);
                this.writeBlock(data);
                str = this.readLineRN(true);
            }
        }
        catch (IOException e) {
            throw new SFTPException(e);
        }
    }

    public byte[] createConfirm(String text) {
        byte[] ret = null;
        try {
            CMSVistaSignedDataGenerator cmsSignedDataGenerator = new CMSVistaSignedDataGenerator();
            byte[] hash = new byte[32];
            GOST3411Digest gost3411Digest = new GOST3411Digest();
            gost3411Digest.update(text.getBytes(), 0, text.length());
            gost3411Digest.doFinal(hash, 0);
            ASN1EncodableVector attr = new ASN1EncodableVector();
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.4"), new DERSet(new DEROctetString(hash))));
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.5"), new DERSet(new DERGeneralizedTime(new Date()))));
            attr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.8"), new DERSet(new X509Name(this.userSignCert.getSubjectDN().getName()))));
            attr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.3"), new DERSet(new DERObjectIdentifier("1.2.840.113549.1.7.1"))));
            AttributeTable attributeTable = new AttributeTable(attr);
            cmsSignedDataGenerator.addSigner((PrivateKey)this.userSignKey, this.userSignCert, CMSSignedDataGenerator.DIGEST_GOST3411G, attributeTable, null);
            CMSProcessableByteArray content = new CMSProcessableByteArray(text.getBytes());
            CMSSignedData signedData = cmsSignedDataGenerator.generate(content, true, GammaTechProvider.PROVIDER_NAME);
            ret = signedData.getEncoded();
        }
        catch (Exception e) {
            throw new SFTPException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] expSesKey(X509Certificate exchCert) {
        Number hCryptProv = 0;
        Number exKeyRC = 0;
        try {
            byte[] simpleBlob = null;
            hCryptProv = this.userExchKey.getHandleProv();
            this.hSesKey = TumarCspFunctions.cpGenKey(hCryptProv, 26655, 1);
            exKeyRC = TumarCspFunctions.cpImportKey(hCryptProv, exchCert.getPublicKey().getEncoded(), exchCert.getPublicKey().getEncoded().length, (Number)0, 0);
            byte[] byArray = simpleBlob = TumarCspFunctions.cpExportKeyData(hCryptProv, this.hSesKey, exKeyRC, 1, 0);
            return byArray;
        }
        finally {
            if (exKeyRC.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hCryptProv, exKeyRC);
            }
            if (this.hSesKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hCryptProv, this.hSesKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ImpSessKey(byte[] simpleBlob, X509Certificate exchCert) {
        Number hCryptProv = 0;
        Number exKeyRC = 0;
        try {
            hCryptProv = this.userExchKey.getHandleProv();
            exKeyRC = TumarCspFunctions.cpImportKey(hCryptProv, exchCert.getPublicKey().getEncoded(), exchCert.getPublicKey().getEncoded().length, (Number)0, 0);
            this.hSesKey = TumarCspFunctions.cpImportKey(hCryptProv, simpleBlob, simpleBlob.length, exKeyRC, 0);
        }
        finally {
            if (exKeyRC.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(hCryptProv, exKeyRC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAuthMessForSend(StringBuilder command) {
        Number hHash = 0;
        Number hCryptProv = this.userExchKey.getHandleProv();
        if (this.hSesKey.intValue() == 0) {
            throw new SFTPException("Session key not initialize");
        }
        try {
            if (this.hHashRc.intValue() == 0) {
                this.hHashRc = TumarCspFunctions.cpCreateHash(hCryptProv, 32799, this.hSesKey, 0);
            }
            TumarCspFunctions.cpHashData(hCryptProv, this.hHashRc, command.toString().getBytes(), command.toString().getBytes().length, 0);
            hHash = TumarCspFunctions.cpDuplicateHash(hCryptProv, this.hHashRc, 0);
            byte[] im = TumarCspFunctions.cpGetHashParamData(hCryptProv, hHash, 2, 0);
            command.append(" [");
            command.append(new String(Base64.encode(im)));
            command.append("]");
        }
        finally {
            if (hHash.intValue() != 0) {
                TumarCspFunctions.cpDestroyHash(hCryptProv, hHash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuthMessForSend(String command) {
        Number hHash = 0;
        Number hCryptProv = this.userExchKey.getHandleProv();
        if (this.hSesKey.intValue() == 0) {
            throw new SFTPException("Session key not initialize");
        }
        if (command.length() < 19) {
            throw new SFTPException("Command to small");
        }
        if (command.charAt(command.length() - 1) != ']') {
            throw new SFTPException("Bad command format");
        }
        try {
            String tmp = command.substring(0, command.indexOf("["));
            String im_vrf = command.substring(command.indexOf("[") + 1, command.indexOf("]") - 1);
            if (this.hHashVr.intValue() == 0) {
                this.hHashVr = TumarCspFunctions.cpCreateHash(hCryptProv, 32799, this.hSesKey, 0);
            }
            TumarCspFunctions.cpHashData(hCryptProv, this.hHashVr, tmp.getBytes(), tmp.getBytes().length, 0);
            hHash = TumarCspFunctions.cpDuplicateHash(hCryptProv, this.hHashVr, 0);
            byte[] im = TumarCspFunctions.cpGetHashParamData(hCryptProv, hHash, 2, 0);
            if (!im_vrf.equals(new String(Base64.encode(im)))) {
                System.out.println(im_vrf + " = " + new String(Base64.encode(im)));
            }
        }
        finally {
            if (hHash.intValue() != 0) {
                TumarCspFunctions.cpDestroyHash(hCryptProv, hHash);
            }
        }
    }

    public void free() {
        try {
            if (this.bi != null) {
                this.bi.close();
            }
            if (this.bo != null) {
                this.bo.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String sendCommand(String comm, String param, boolean flag) throws IOException {
        String ret = "";
        StringBuilder command = new StringBuilder();
        command.append(comm);
        command.append(" ");
        command.append(param);
        if (flag) {
            this.getAuthMessForSend(command);
        }
        System.out.println(">>>> " + command.toString());
        this.bo.write(DataConverter.stringToByteArray(command.toString()));
        this.bo.flush();
        return ret;
    }

    private InetAddress createInetAddress(String host) throws UnknownHostException {
        InetAddress addr = this.parseIPv4Address(host);
        if (addr != null) {
            return addr;
        }
        return InetAddress.getByName(host);
    }

    private InetAddress parseIPv4Address(String host) throws UnknownHostException {
        if (host == null) {
            return null;
        }
        String[] quad = Tokenizer.parseTokens(host, '.');
        if (quad == null || quad.length != 4) {
            return null;
        }
        byte[] addr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int part = 0;
            if (quad[i].length() == 0 || quad[i].length() > 3) {
                return null;
            }
            for (int k = 0; k < quad[i].length(); ++k) {
                char c = quad[i].charAt(k);
                if (c < '0' || c > '9') {
                    return null;
                }
                part = part * 10 + (c - 48);
            }
            if (part > 255) {
                return null;
            }
            addr[i] = (byte)part;
        }
        return InetAddress.getByAddress(host, addr);
    }

    private String readLineRN(boolean flag) throws IOException {
        block5: {
            int pos = 0;
            int len = 0;
            Arrays.fill(this.buf, (byte)0);
            do {
                int c;
                if ((c = this.bi.read()) == -1) {
                    throw new IOException("Premature connection close");
                }
                this.buf[pos++] = (byte)c;
                if (c == 0 || c == 10) break block5;
                ++len;
            } while (pos < this.buf.length);
            throw new IOException("The server sent a too long line.");
        }
        String ret = new String(this.buf, 0, DataConverter.getSizeWithoutNulls(this.buf, 0), "CP1251");
        if (ret.length() <= 0) {
            ret = this.readLineRN(flag);
        } else {
            System.out.println("<<<< " + ret);
            if (flag) {
                this.checkAuthMessForSend(ret);
            }
        }
        return ret;
    }

    private int readBlock(byte[] buffer) throws IOException {
        int pos = 0;
        int len = 0;
        Arrays.fill(buffer, (byte)0);
        do {
            int c;
            if ((c = this.bi.read()) == -1) {
                throw new IOException("Premature connection close");
            }
            buffer[pos++] = (byte)c;
            ++len;
        } while (pos < buffer.length);
        return len;
    }

    private void writeBlock(byte[] buffer) throws IOException {
        this.bo.write(buffer);
        this.bo.flush();
    }

    private X509Certificate getCertificate(String DN, String sn, String url) {
        X509Certificate ret = null;
        boolean isTrue = false;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "SIMPLE");
            env.put("java.naming.provider.url", url);
            env.put("java.naming.security.principal", "");
            env.put("java.naming.security.credentials", "");
            env.put("java.naming.ldap.attributes.binary", "userCertificate");
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> answer = ctx.search(DN, "(&(userCertificate=*))", ctls);
            if (answer.hasMoreElements()) {
                while (answer.hasMore() && !isTrue) {
                    SearchResult sr = answer.next();
                    Attributes pp = sr.getAttributes();
                    NamingEnumeration<? extends javax.naming.directory.Attribute> e = pp.getAll();
                    block3: while (e.hasMoreElements() && !isTrue) {
                        javax.naming.directory.Attribute attr = (javax.naming.directory.Attribute)e.nextElement();
                        String attrID = attr.getID();
                        if (!attrID.equals("userCertificate")) continue;
                        for (int i = 0; i < attr.size(); ++i) {
                            Object csd = attr.get(i);
                            byte[] csd_b = (byte[])csd;
                            ByteArrayInputStream bis1 = new ByteArrayInputStream(csd_b);
                            CertificateFactory cf1 = CertificateFactory.getInstance("X.509");
                            Collection<? extends Certificate> c1 = cf1.generateCertificates(bis1);
                            Iterator<? extends Certificate> i1 = c1.iterator();
                            ret = (X509Certificate)i1.next();
                            if (!UtilCM.array2hex(ret.getSerialNumber().toByteArray()).equals(sn)) continue;
                            isTrue = true;
                            continue block3;
                        }
                    }
                }
            }
            ctx.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public JCEECPrivateKey getUserSignKey() {
        return this.userSignKey;
    }

    public JCEECPrivateKey getUserExchKey() {
        return this.userExchKey;
    }

    public X509Certificate getUserSignCert() {
        return this.userSignCert;
    }

    public X509Certificate getUserExchCert() {
        return this.userExchCert;
    }

    public boolean isFileExists(String fileName) {
        boolean ret = true;
        try {
            this.sendCommand("RETR", fileName, true);
            String str = this.readLineRN(true);
            if (str.charAt(0) == '-') {
                ret = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public X509Certificate getServerExchCert() {
        return this.serverExchCert;
    }

    public X509Certificate getServerSignCert() {
        return this.serverSignCert;
    }
}

