/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cmp;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.AlgorithmIdentifier;

public class Challenge
extends ASN1Encodable {
    private AlgorithmIdentifier owf;
    private ASN1OctetString witness;
    private ASN1OctetString challenge;

    private Challenge(ASN1Sequence seq) {
        int index = 0;
        if (seq.size() == 3) {
            this.owf = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(index++));
        }
        this.witness = ASN1OctetString.getInstance((Object)seq.getObjectAt(index++));
        this.challenge = ASN1OctetString.getInstance((Object)seq.getObjectAt(index));
    }

    public static Challenge getInstance(Object o) {
        if (o instanceof Challenge) {
            return (Challenge)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new Challenge((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public AlgorithmIdentifier getOwf() {
        return this.owf;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        this.addOptional(v, (ASN1Encodable)this.owf);
        v.add((DEREncodable)this.witness);
        v.add((DEREncodable)this.challenge);
        return new DERSequence((DEREncodableVector)v);
    }

    private void addOptional(ASN1EncodableVector v, ASN1Encodable obj) {
        if (obj != null) {
            v.add((DEREncodable)obj);
        }
    }
}

