/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cmp;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DERSequence;

public class InfoTypeAndValue
extends ASN1Encodable {
    private DERObjectIdentifier infoType;
    private ASN1Encodable infoValue;

    private InfoTypeAndValue(ASN1Sequence seq) {
        this.infoType = DERObjectIdentifier.getInstance((Object)seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.infoValue = (ASN1Encodable)seq.getObjectAt(1);
        }
    }

    public static InfoTypeAndValue getInstance(Object o) {
        if (o instanceof InfoTypeAndValue) {
            return (InfoTypeAndValue)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new InfoTypeAndValue((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public DERObjectIdentifier getInfoType() {
        return this.infoType;
    }

    public ASN1Encodable getInfoValue() {
        return this.infoValue;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.infoType);
        if (this.infoValue != null) {
            v.add((DEREncodable)this.infoValue);
        }
        return new DERSequence((DEREncodableVector)v);
    }
}

