/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cmp;

import java.util.Enumeration;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cmp.PKIFreeText;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.GeneralName;

public class PKIHeader
extends ASN1Encodable {
    private DERInteger pvno;
    private GeneralName sender;
    private GeneralName recipient;
    private DERGeneralizedTime messageTime;
    private AlgorithmIdentifier protectionAlg;
    private ASN1OctetString senderKID;
    private ASN1OctetString recipKID;
    private ASN1OctetString transactionID;
    private ASN1OctetString senderNonce;
    private ASN1OctetString recipNonce;
    private PKIFreeText freeText;
    private ASN1Sequence generalInfo;

    private PKIHeader(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.pvno = DERInteger.getInstance(en.nextElement());
        this.sender = GeneralName.getInstance(en.nextElement());
        this.recipient = GeneralName.getInstance(en.nextElement());
        block11: while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            switch (tObj.getTagNo()) {
                case 0: {
                    this.messageTime = DERGeneralizedTime.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    continue block11;
                }
                case 1: {
                    this.protectionAlg = AlgorithmIdentifier.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    continue block11;
                }
                case 2: {
                    this.senderKID = ASN1OctetString.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    continue block11;
                }
                case 3: {
                    this.recipKID = ASN1OctetString.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    continue block11;
                }
                case 4: {
                    this.transactionID = ASN1OctetString.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    continue block11;
                }
                case 5: {
                    this.senderNonce = ASN1OctetString.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    continue block11;
                }
                case 6: {
                    this.recipNonce = ASN1OctetString.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    continue block11;
                }
                case 7: {
                    this.freeText = PKIFreeText.getInstance(tObj, true);
                    continue block11;
                }
                case 8: {
                    this.generalInfo = ASN1Sequence.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + tObj.getTagNo());
        }
    }

    public static PKIHeader getInstance(Object o) {
        if (o instanceof PKIHeader) {
            return (PKIHeader)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new PKIHeader((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public DERInteger getPvno() {
        return this.pvno;
    }

    public GeneralName getSender() {
        return this.sender;
    }

    public GeneralName getRecipient() {
        return this.recipient;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.pvno);
        v.add((DEREncodable)this.sender);
        v.add((DEREncodable)this.recipient);
        this.addOptional(v, 0, (ASN1Encodable)this.messageTime);
        this.addOptional(v, 1, (ASN1Encodable)this.protectionAlg);
        this.addOptional(v, 2, (ASN1Encodable)this.senderKID);
        this.addOptional(v, 3, (ASN1Encodable)this.recipKID);
        this.addOptional(v, 4, (ASN1Encodable)this.transactionID);
        this.addOptional(v, 5, (ASN1Encodable)this.senderNonce);
        this.addOptional(v, 6, (ASN1Encodable)this.recipNonce);
        this.addOptional(v, 7, this.freeText);
        this.addOptional(v, 8, (ASN1Encodable)this.generalInfo);
        return new DERSequence((DEREncodableVector)v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((DEREncodable)new DERTaggedObject(true, tagNo, (DEREncodable)obj));
        }
    }
}

