/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cmp;

import java.util.Enumeration;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERBitString;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cmp.PKIBody;
import kz.gamma.asn1.cmp.PKIHeader;

public class PKIMessage
extends ASN1Encodable {
    private PKIHeader header;
    private PKIBody body;
    private DERBitString protection;
    private ASN1Sequence extraCerts;

    private PKIMessage(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.header = PKIHeader.getInstance(en.nextElement());
        this.body = PKIBody.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            if (tObj.getTagNo() == 0) {
                this.protection = DERBitString.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                continue;
            }
            this.extraCerts = ASN1Sequence.getInstance((ASN1TaggedObject)tObj, (boolean)true);
        }
    }

    public static PKIMessage getInstance(Object o) {
        if (o instanceof PKIMessage) {
            return (PKIMessage)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new PKIMessage((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.header);
        v.add((DEREncodable)this.body);
        this.addOptional(v, 0, (ASN1Encodable)this.protection);
        this.addOptional(v, 1, (ASN1Encodable)this.extraCerts);
        return new DERSequence((DEREncodableVector)v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((DEREncodable)new DERTaggedObject(true, tagNo, (DEREncodable)obj));
        }
    }
}

