/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cmp;

import java.util.Enumeration;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.cmp.PKIStatusInfo;
import kz.gamma.asn1.crmf.CertId;
import kz.gamma.asn1.x509.CertificateList;

public class RevRepContent
extends ASN1Encodable {
    private ASN1Sequence status;
    private ASN1Sequence revCerts;
    private ASN1Sequence crls;

    private RevRepContent(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.status = ASN1Sequence.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = ASN1TaggedObject.getInstance(en.nextElement());
            if (tObj.getTagNo() == 0) {
                this.revCerts = ASN1Sequence.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                continue;
            }
            this.crls = ASN1Sequence.getInstance((ASN1TaggedObject)tObj, (boolean)true);
        }
    }

    public static RevRepContent getInstance(Object o) {
        if (o instanceof RevRepContent) {
            return (RevRepContent)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new RevRepContent((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public PKIStatusInfo[] getStatus() {
        PKIStatusInfo[] results = new PKIStatusInfo[this.status.size()];
        for (int i = 0; i != results.length; ++i) {
            results[i] = PKIStatusInfo.getInstance(this.status.getObjectAt(i));
        }
        return results;
    }

    public CertId[] getRevCerts() {
        if (this.revCerts == null) {
            return null;
        }
        CertId[] results = new CertId[this.revCerts.size()];
        for (int i = 0; i != results.length; ++i) {
            results[i] = CertId.getInstance(this.revCerts.getObjectAt(i));
        }
        return results;
    }

    public CertificateList[] getCrls() {
        if (this.crls == null) {
            return null;
        }
        CertificateList[] results = new CertificateList[this.crls.size()];
        for (int i = 0; i != results.length; ++i) {
            results[i] = CertificateList.getInstance((Object)this.crls.getObjectAt(i));
        }
        return results;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.status);
        this.addOptional(v, 0, (ASN1Encodable)this.revCerts);
        this.addOptional(v, 1, (ASN1Encodable)this.crls);
        return new DERSequence((DEREncodableVector)v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((DEREncodable)new DERTaggedObject(true, tagNo, (DEREncodable)obj));
        }
    }
}

