/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.crmf;

import java.util.Enumeration;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.Time;

public class OptionalValidity
extends ASN1Encodable {
    private Time notBefore;
    private Time notAfter;

    private OptionalValidity(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            if (tObj.getTagNo() == 0) {
                this.notBefore = Time.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                continue;
            }
            this.notAfter = Time.getInstance((ASN1TaggedObject)tObj, (boolean)false);
        }
    }

    public static OptionalValidity getInstance(Object o) {
        if (o instanceof OptionalValidity) {
            return (OptionalValidity)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new OptionalValidity((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.notBefore);
        v.add((DEREncodable)this.notAfter);
        return new DERSequence((DEREncodableVector)v);
    }
}

