/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERTaggedObject;

public class AdminSecretInfo {
    public byte[] createAddBody(Map params) throws UnsupportedEncodingException {
        String trustName;
        String displayName;
        String telephoneNumber;
        Date birthDate;
        String country;
        String state;
        String city;
        String organization;
        String commonName;
        String uidInDn;
        StringBuilder dn = new StringBuilder();
        String mail = (String)params.get("mail");
        if (mail != null && mail.trim().length() > 0) {
            dn.append("E=").append(mail).append(";");
        }
        if ((uidInDn = (String)params.get("uidInDn")) != null && uidInDn.trim().length() > 0) {
            dn.append("UID=").append(uidInDn).append(";");
        }
        if ((commonName = (String)params.get("commonName")) == null || commonName.trim().length() == 0) {
            throw new NullPointerException("commonName is required");
        }
        dn.append("CN=").append(commonName).append(";");
        String organizationalUnit = (String)params.get("organizationalUnit");
        if (organizationalUnit != null && organizationalUnit.trim().length() > 0) {
            dn.append("OU=").append(organizationalUnit).append(";");
        }
        if ((organization = (String)params.get("organization")) != null && organization.trim().length() > 0) {
            dn.append("O=").append(organization).append(";");
        }
        if ((city = (String)params.get("city")) != null && city.trim().length() > 0) {
            dn.append("L=").append(city).append(";");
        }
        if ((state = (String)params.get("state")) != null && state.trim().length() > 0) {
            dn.append("ST=").append(state).append(";");
        }
        if ((country = (String)params.get("country")) == null || country.trim().length() == 0) {
            throw new NullPointerException("country is required");
        }
        dn.append("C=").append(country).append(";");
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        if (dn.toString().length() > 0) {
            rootVector.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)new DEROctetString(dn.toString().getBytes("cp1251"))));
        }
        ASN1EncodableVector vectorAttributes = new ASN1EncodableVector();
        ASN1EncodableVector userNameVector = new ASN1EncodableVector();
        DEROctetString userNameDescription = new DEROctetString("userName".getBytes());
        userNameVector.add((DEREncodable)userNameDescription);
        DEROctetString userNameValue = new DEROctetString(dn.toString().getBytes());
        DERSet userNameSet = new DERSet((DEREncodable)userNameValue);
        userNameVector.add((DEREncodable)userNameSet);
        vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)userNameVector));
        String uid = (String)params.get("uid");
        if (uid == null || uid.trim().length() == 0) {
            throw new NullPointerException("uid is required");
        }
        ASN1EncodableVector uidVector = new ASN1EncodableVector();
        DEROctetString uidDescription = new DEROctetString("uid".getBytes());
        uidVector.add((DEREncodable)uidDescription);
        DEROctetString uidValue = new DEROctetString(uid.getBytes());
        DERSet uidSet = new DERSet((DEREncodable)uidValue);
        uidVector.add((DEREncodable)uidSet);
        vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)uidVector));
        String userPassword = (String)params.get("userPassword");
        if (userPassword == null || userPassword.trim().length() == 0) {
            throw new NullPointerException("userPassword is required");
        }
        ASN1EncodableVector userPasswordVector = new ASN1EncodableVector();
        DEROctetString userPasswordDescription = new DEROctetString("userPassword".getBytes());
        userPasswordVector.add((DEREncodable)userPasswordDescription);
        DEROctetString userPasswordValue = new DEROctetString(userPassword.getBytes());
        DERSet userPasswordSet = new DERSet((DEREncodable)userPasswordValue);
        userPasswordVector.add((DEREncodable)userPasswordSet);
        vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)userPasswordVector));
        Boolean userState = (Boolean)params.get("userState");
        if (userState != null) {
            ASN1EncodableVector userStateVector = new ASN1EncodableVector();
            DEROctetString userStateDescription = new DEROctetString("userState".getBytes());
            userStateVector.add((DEREncodable)userStateDescription);
            DEROctetString userStateValue = null;
            userStateValue = userState != false ? new DEROctetString("1".getBytes()) : new DEROctetString("0".getBytes());
            DERSet userStateSet = new DERSet((DEREncodable)userStateValue);
            userStateVector.add((DEREncodable)userStateSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)userStateVector));
        }
        if ((birthDate = (Date)params.get("birthDate")) != null) {
            ASN1EncodableVector birthDateVector = new ASN1EncodableVector();
            DEROctetString birthDateDescription = new DEROctetString("birthDate".getBytes());
            birthDateVector.add((DEREncodable)birthDateDescription);
            DERGeneralizedTime genTime = new DERGeneralizedTime(birthDate);
            DEROctetString birthDateValue = new DEROctetString(genTime.getTimeString().getBytes());
            DERSet birthDateSet = new DERSet((DEREncodable)birthDateValue);
            birthDateVector.add((DEREncodable)birthDateSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)birthDateVector));
        }
        if ((telephoneNumber = (String)params.get("telephoneNumber")) != null && telephoneNumber.trim().length() > 0) {
            ASN1EncodableVector telephoneNumberVector = new ASN1EncodableVector();
            DEROctetString telephoneNumberDescription = new DEROctetString("telephoneNumber".getBytes());
            telephoneNumberVector.add((DEREncodable)telephoneNumberDescription);
            DEROctetString telephoneNumberValue = new DEROctetString(telephoneNumber.getBytes());
            DERSet telephoneNumberSet = new DERSet((DEREncodable)telephoneNumberValue);
            telephoneNumberVector.add((DEREncodable)telephoneNumberSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)telephoneNumberVector));
        }
        if (mail != null && mail.trim().length() > 0) {
            ASN1EncodableVector mailVector = new ASN1EncodableVector();
            DEROctetString mailDescription = new DEROctetString("mail".getBytes());
            mailVector.add((DEREncodable)mailDescription);
            DEROctetString mailValue = new DEROctetString(mail.getBytes());
            DERSet mailSet = new DERSet((DEREncodable)mailValue);
            mailVector.add((DEREncodable)mailSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)mailVector));
        }
        if ((displayName = (String)params.get("displayName")) != null && displayName.trim().length() > 0) {
            ASN1EncodableVector displayNameVector = new ASN1EncodableVector();
            DEROctetString displayNameDescription = new DEROctetString("displayName".getBytes());
            displayNameVector.add((DEREncodable)displayNameDescription);
            DEROctetString displayNameValue = new DEROctetString(displayName.getBytes());
            DERSet displayNameSet = new DERSet((DEREncodable)displayNameValue);
            displayNameVector.add((DEREncodable)displayNameSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)displayNameVector));
        }
        if ((trustName = (String)params.get("trustName")) != null && trustName.trim().length() > 0) {
            ASN1EncodableVector trustNameVector = new ASN1EncodableVector();
            DEROctetString trustNameDescription = new DEROctetString("trustName".getBytes());
            trustNameVector.add((DEREncodable)trustNameDescription);
            DEROctetString trustNameValue = new DEROctetString(trustName.getBytes());
            DERSet trustNameSet = new DERSet((DEREncodable)trustNameValue);
            trustNameVector.add((DEREncodable)trustNameSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)trustNameVector));
        }
        rootVector.add((DEREncodable)new DERSequence((DEREncodableVector)vectorAttributes));
        return new DERSequence((DEREncodableVector)rootVector).getDEREncoded();
    }

    public byte[] createModBody(Map params) throws UnsupportedEncodingException {
        String trustName;
        String displayName;
        String mail;
        String telephoneNumber;
        Date birthDate;
        Boolean userState;
        String userPassword;
        String userName = (String)params.get("userName");
        if (userName == null || userName.trim().length() == 0) {
            throw new NullPointerException("userName is required");
        }
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        ASN1EncodableVector vectorAttributes = new ASN1EncodableVector();
        rootVector.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)new DEROctetString(userName.getBytes("cp1251"))));
        String uid = (String)params.get("uid");
        if (uid != null && uid.trim().length() > 0) {
            ASN1EncodableVector uidVector = new ASN1EncodableVector();
            DEROctetString uidDescription = new DEROctetString("uid".getBytes());
            uidVector.add((DEREncodable)uidDescription);
            DEROctetString uidValue = new DEROctetString(uid.getBytes());
            DERSet uidSet = new DERSet((DEREncodable)uidValue);
            uidVector.add((DEREncodable)uidSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)uidVector));
        }
        if ((userPassword = (String)params.get("userPassword")) != null && userPassword.trim().length() > 0) {
            ASN1EncodableVector userPasswordVector = new ASN1EncodableVector();
            DEROctetString userPasswordDescription = new DEROctetString("userPassword".getBytes());
            userPasswordVector.add((DEREncodable)userPasswordDescription);
            DEROctetString userPasswordValue = new DEROctetString(userPassword.getBytes());
            DERSet userPasswordSet = new DERSet((DEREncodable)userPasswordValue);
            userPasswordVector.add((DEREncodable)userPasswordSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)userPasswordVector));
        }
        if ((userState = (Boolean)params.get("userState")) != null) {
            ASN1EncodableVector userStateVector = new ASN1EncodableVector();
            DEROctetString userStateDescription = new DEROctetString("userState".getBytes());
            userStateVector.add((DEREncodable)userStateDescription);
            DEROctetString userStateValue = null;
            userStateValue = userState != false ? new DEROctetString("1".getBytes()) : new DEROctetString("0".getBytes());
            DERSet userStateSet = new DERSet((DEREncodable)userStateValue);
            userStateVector.add((DEREncodable)userStateSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)userStateVector));
        }
        if ((birthDate = (Date)params.get("birthDate")) != null) {
            ASN1EncodableVector birthDateVector = new ASN1EncodableVector();
            DEROctetString birthDateDescription = new DEROctetString("birthDate".getBytes());
            birthDateVector.add((DEREncodable)birthDateDescription);
            DERGeneralizedTime genTime = new DERGeneralizedTime(birthDate);
            DEROctetString birthDateValue = new DEROctetString(genTime.getTimeString().getBytes());
            DERSet birthDateSet = new DERSet((DEREncodable)birthDateValue);
            birthDateVector.add((DEREncodable)birthDateSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)birthDateVector));
        }
        if ((telephoneNumber = (String)params.get("telephoneNumber")) != null && telephoneNumber.trim().length() > 0) {
            ASN1EncodableVector telephoneNumberVector = new ASN1EncodableVector();
            DEROctetString telephoneNumberDescription = new DEROctetString("telephoneNumber".getBytes());
            telephoneNumberVector.add((DEREncodable)telephoneNumberDescription);
            DEROctetString telephoneNumberValue = new DEROctetString(telephoneNumber.getBytes());
            DERSet telephoneNumberSet = new DERSet((DEREncodable)telephoneNumberValue);
            telephoneNumberVector.add((DEREncodable)telephoneNumberSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)telephoneNumberVector));
        }
        if ((mail = (String)params.get("mail")) != null && mail.trim().length() > 0) {
            ASN1EncodableVector mailVector = new ASN1EncodableVector();
            DEROctetString mailDescription = new DEROctetString("mail".getBytes());
            mailVector.add((DEREncodable)mailDescription);
            DEROctetString mailValue = new DEROctetString(mail.getBytes());
            DERSet mailSet = new DERSet((DEREncodable)mailValue);
            mailVector.add((DEREncodable)mailSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)mailVector));
        }
        if ((displayName = (String)params.get("displayName")) != null && displayName.trim().length() > 0) {
            ASN1EncodableVector displayNameVector = new ASN1EncodableVector();
            DEROctetString displayNameDescription = new DEROctetString("displayName".getBytes());
            displayNameVector.add((DEREncodable)displayNameDescription);
            DEROctetString displayNameValue = new DEROctetString(displayName.getBytes());
            DERSet displayNameSet = new DERSet((DEREncodable)displayNameValue);
            displayNameVector.add((DEREncodable)displayNameSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)displayNameVector));
        }
        if ((trustName = (String)params.get("trustName")) != null && trustName.trim().length() > 0) {
            ASN1EncodableVector trustNameVector = new ASN1EncodableVector();
            DEROctetString trustNameDescription = new DEROctetString("trustName".getBytes());
            trustNameVector.add((DEREncodable)trustNameDescription);
            DEROctetString trustNameValue = new DEROctetString(trustName.getBytes());
            DERSet trustNameSet = new DERSet((DEREncodable)trustNameValue);
            trustNameVector.add((DEREncodable)trustNameSet);
            vectorAttributes.add((DEREncodable)new DERSequence((DEREncodableVector)trustNameVector));
        }
        rootVector.add((DEREncodable)new DERSequence((DEREncodableVector)vectorAttributes));
        return new DERSequence((DEREncodableVector)rootVector).getDEREncoded();
    }

    public byte[] createDelBody(Map params) throws UnsupportedEncodingException {
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        String uid = (String)params.get("uid");
        if (uid != null && uid.trim().length() > 0) {
            rootVector.add((DEREncodable)new DEROctetString(uid.getBytes()));
        } else {
            rootVector.add((DEREncodable)new DEROctetString("".getBytes()));
        }
        String userName = (String)params.get("userName");
        if (userName == null || userName.trim().length() <= 0) {
            throw new NullPointerException("parameter userName is required");
        }
        rootVector.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)new DEROctetString(userName.getBytes("cp1251"))));
        return new DERSequence((DEREncodableVector)rootVector).getDEREncoded();
    }

    public byte[] createGetBody(Map params) throws UnsupportedEncodingException {
        String userName = (String)params.get("userName");
        if (userName == null || userName.trim().length() == 0) {
            throw new NullPointerException("userName is required");
        }
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        ASN1EncodableVector vectorAttributes = new ASN1EncodableVector();
        rootVector.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)new DEROctetString(userName.getBytes("cp1251"))));
        DEROctetString uidDescription = new DEROctetString("uid".getBytes());
        vectorAttributes.add((DEREncodable)uidDescription);
        DEROctetString userPasswordDescription = new DEROctetString("userPassword".getBytes());
        vectorAttributes.add((DEREncodable)userPasswordDescription);
        DEROctetString userStateDescription = new DEROctetString("userState".getBytes());
        vectorAttributes.add((DEREncodable)userStateDescription);
        DEROctetString birthDateDescription = new DEROctetString("birthDate".getBytes());
        vectorAttributes.add((DEREncodable)birthDateDescription);
        DEROctetString telephoneNumberDescription = new DEROctetString("telephoneNumber".getBytes());
        vectorAttributes.add((DEREncodable)telephoneNumberDescription);
        DEROctetString mailDescription = new DEROctetString("mail".getBytes());
        vectorAttributes.add((DEREncodable)mailDescription);
        DEROctetString displayNameDescription = new DEROctetString("displayName".getBytes());
        vectorAttributes.add((DEREncodable)displayNameDescription);
        DEROctetString trustNameDescription = new DEROctetString("trustName".getBytes());
        vectorAttributes.add((DEREncodable)trustNameDescription);
        rootVector.add((DEREncodable)new DERSequence((DEREncodableVector)vectorAttributes));
        return new DERSequence((DEREncodableVector)rootVector).getDEREncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map parseBody(byte[] body) throws IOException {
        ASN1InputStream in = null;
        try {
            in = new ASN1InputStream(body);
            DERSequence asnBody = (DERSequence)in.readObject();
            DERTaggedObject data = (DERTaggedObject)asnBody.getObjectAt(0);
            DEROctetString dataString = (DEROctetString)DEROctetString.getInstance((Object)data);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            if (data.getTagNo() == 0) {
                resultMap.put("userName", new String(dataString.getOctets()));
            } else if (data.getTagNo() == 1) {
                resultMap.put("uid", new String(dataString.getOctets()));
            } else {
                throw new RuntimeException("Unknown tagNo value: " + data.getTagNo());
            }
            DERSequence attributesSequence = (DERSequence)asnBody.getObjectAt(1);
            Enumeration attributesEnum = attributesSequence.getObjects();
            while (attributesEnum.hasMoreElements()) {
                DERSequence element = (DERSequence)attributesEnum.nextElement();
                DERSet derSetValue = (DERSet)element.getObjectAt(1);
                if (derSetValue.size() <= 0) continue;
                DEROctetString octetStringDescription = (DEROctetString)element.getObjectAt(0);
                String description = new String(octetStringDescription.getOctets());
                DEROctetString octetStringValue = (DEROctetString)derSetValue.getObjectAt(0);
                if (description.equals("userState")) {
                    String userState = new String(octetStringValue.getOctets());
                    if (userState.equals("0")) {
                        resultMap.put(description, false);
                        continue;
                    }
                    resultMap.put(description, true);
                    continue;
                }
                if (description.equals("birthDate")) {
                    DERGeneralizedTime genTime = new DERGeneralizedTime(new String(octetStringValue.getOctets()));
                    try {
                        resultMap.put(description, genTime.getDate());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String value = new String(octetStringValue.getOctets());
                resultMap.put(description, value);
            }
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

