/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.cmp.CmpData;
import kz.gamma.cmp.CmpInfo;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;

public abstract class CmpResponse
extends CmpData {
    protected byte[] response;
    protected int responseTypeCode;
    protected String responseType;
    protected String errorCmpStatus;
    protected String errorCmpFail;
    protected byte[] signerCertificate;
    protected byte[] usefulData;

    public byte[] getResponse() {
        return this.response;
    }

    public int getResponseTypeCode() {
        return this.responseTypeCode;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getErrorCmpStatus() {
        return this.errorCmpStatus;
    }

    public String getErrorCmpFail() {
        return this.errorCmpFail;
    }

    public byte[] getSignerCertificate() {
        return this.signerCertificate;
    }

    public byte[] getUsefulData() {
        return this.usefulData;
    }

    @Override
    protected void initFields() {
        super.initFields();
        this.response = null;
        this.responseTypeCode = 0;
        this.responseType = null;
        this.errorCmpStatus = null;
        this.errorCmpFail = null;
        this.signerCertificate = null;
        this.usefulData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyResponse(Map params) {
        try {
            this.initFields();
            this.profile = (String)params.get("profile");
            if (this.profile == null || this.profile.trim().length() == 0) {
                throw new NullPointerException("parameter profile is required");
            }
            this.response = (byte[])params.get("response");
            if (this.response == null) {
                throw new NullPointerException("parameter response is required");
            }
            this.acquireContextFlag = (Integer)params.get("acquireContextFlag");
            if (this.acquireContextFlag == null) {
                throw new NullPointerException("parameter acquireContextFlag is required");
            }
            boolean profileChecking = ProfileParams.isProfile((String)this.profile);
            if (profileChecking) {
                try {
                    Boolean result = this.profileInfo.isProfileExists(this.profile);
                    if (!(result != null && result.booleanValue() || this.acquireContextFlag == -268435456)) {
                        System.out.println("Profile \"" + this.profile + "\" is not exists. Try to create");
                        this.profileCreator.createProfile(this.profile, "file", this.profile, "", this.fileHelper.getDefaultKeysPath(), "bin", Integer.valueOf(41041), Integer.valueOf(43578));
                        System.out.println("Profile \"" + this.profile + "\" created");
                    }
                }
                catch (Exception e) {
                    System.err.println("Cannot create profile: " + this.profile);
                    e.printStackTrace();
                }
                this.profile = ProfileParams.getProfileName((String)this.profile, (Boolean)true);
            }
            this.handleProv = TumarCspFunctions.cpAcquireContext((String)this.profile, (int)this.acquireContextFlag, (Number)LibraryWrapper.PV_TABLE);
            if (!profileChecking) {
                String serialNumber = this.profileInfo.getDataFromUrl(this.profile, Integer.valueOf(1));
                try {
                    KeyParams keyParams = new KeyParams(this.handleProv);
                    Object[] algID = keyParams.getKeyAlgIDList();
                    CSPUtil cspUtil = new CSPUtil();
                    this.profileKeySpec = cspUtil.getTypeKey(((Integer)algID[keyParams.getIndexSN(serialNumber)]).intValue());
                }
                catch (Exception e) {
                    throw new RuntimeCryptoException("Cannot obtain key usage for key with serial number: " + serialNumber);
                }
            }
            this.handleKey1 = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])this.response, (int)this.response.length, (Number)0, (int)0);
            byte[] type = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)80, (int)0);
            this.responseTypeCode = UtilCM.byteToInt((byte[])type, (int)0, (int)1);
            this.responseType = CmpInfo.codeToResponseType(this.responseTypeCode);
            if (this.responseTypeCode == 23) {
                byte[] status = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)77, (int)0);
                int statusInt = UtilCM.byteToInt((byte[])status, (int)0, (int)1);
                this.errorCmpStatus = CmpInfo.codeToStatus(statusInt);
                try {
                    byte[] fail = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)75, (int)0);
                    int failInt = UtilCM.byteToInt((byte[])fail, (int)0, (int)1);
                    if (failInt != 255) {
                        this.errorCmpFail = CmpInfo.codeToFail((int)failInt);
                    }
                }
                catch (Exception e) {
                    this.errorCmpFail = null;
                }
                boolean e = false;
                return e;
            }
            byte[] transId = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)81, (int)0);
            this.transactionId = new String(transId);
            this.signerCertificate = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)26, (int)0);
            String userPassword = (String)params.get("userPassword");
            if (this.signerCertificate != null && (userPassword == null || userPassword.trim().length() == 0)) {
                Number hCaKey = null;
                try {
                    hCaKey = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)2);
                    this.caCertificate = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)hCaKey, (int)68, (int)0);
                    if (this.caCertificate != null) {
                        TumarCspFunctions.cpVerifySignature((Number)this.handleProv, (Number)0, (byte[])this.signerCertificate, (int)this.signerCertificate.length, (Number)0, null, (int)0x1000000);
                    }
                }
                catch (Exception e) {
                    this.caCertificate = null;
                }
                finally {
                    if (hCaKey.longValue() != 0L) {
                        TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)hCaKey);
                    }
                }
                this.handleKey2 = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])this.signerCertificate, (int)this.signerCertificate.length, (Number)0, (int)0);
                TumarCspFunctions.cpVerifySignature((Number)this.handleProv, (Number)0, (byte[])this.response, (int)this.response.length, (Number)this.handleKey2, (String)"", (int)0x8000000);
            }
            boolean bl = this.verify(params);
            return bl;
        }
        finally {
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)this.handleKey1);
            }
            if (this.handleKey2.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)this.handleKey2);
            }
            if (this.handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext((Number)this.handleProv, (int)0);
            }
        }
    }

    protected abstract boolean verify(Map var1);
}

