/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import kz.gamma.cmp.CmpResponse;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class DepositionResponse
extends CmpResponse {
    private Date time;

    @Override
    protected boolean verify(Map params) {
        this.response = (byte[])params.get("response");
        String userPassword = (String)params.get("userPassword");
        String otp = (String)params.get("otp");
        if (otp == null || otp.trim().length() == 0) {
            return this.verifyOutResponse(userPassword, this.response);
        }
        return this.verifyInResponse(userPassword, otp, this.response);
    }

    private boolean verifyOutResponse(String userPassword, byte[] response) {
        if (this.responseTypeCode == 22) {
            byte[] timeAsBytes = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)78, (int)0);
            try {
                this.time = DateUtils.getInstance().stringToDate(new String(timeAsBytes));
            }
            catch (ParseException e) {
                this.time = null;
            }
        } else {
            throw new RuntimeCryptoException("Unknown (out) deposition response type: " + this.responseTypeCode);
        }
        this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)0);
        TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)87, (byte[])DataConverter.stringToByteArray((String)userPassword), (int)0);
        TumarCspFunctions.cpVerifySignature((Number)this.handleProv, (Number)0, (byte[])response, (int)response.length, (Number)this.handleKey2, (String)"", (int)0x8000000);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean verifyInResponse(String userPassword, String otp, byte[] response) {
        Number handleKey3 = 0;
        try {
            if (this.responseTypeCode == 22) {
                TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)90, (byte[])DataConverter.stringToByteArray((String)"1.3.6.1.5.5.7.4.50.2"), (int)0);
                if (this.handleKey2.longValue() != 0L) {
                    TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)this.handleKey2);
                }
            } else {
                throw new RuntimeCryptoException("Unknown (in) deposition response type: " + this.responseTypeCode);
            }
            this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)87, (byte[])DataConverter.stringToByteArray((String)userPassword), (int)0);
            TumarCspFunctions.cpVerifySignature((Number)this.handleProv, (Number)0, (byte[])response, (int)response.length, (Number)this.handleKey2, (String)"", (int)0x8000000);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)87, (byte[])DataConverter.stringToByteArray((String)userPassword), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)99, (byte[])DataConverter.stringToByteArray((String)otp), (int)0);
            byte[] keyContainer = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)92, (int)0);
            handleKey3 = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])keyContainer, (int)keyContainer.length, (Number)0, (int)1);
            Boolean bl = true;
            return bl;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)handleKey3);
            }
        }
    }

    public Date getTime() {
        return this.time;
    }
}

