/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import kz.gamma.cmp.CmpRequest;
import kz.gamma.core.UtilCM;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class KeyUpdateRequest
extends CmpRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] create(Map params) {
        LinkedList<Number> hNewKeyList = new LinkedList<Number>();
        try {
            Date notAfter = (Date)params.get("notAfter");
            if (notAfter == null) {
                throw new NullPointerException("parameter notAfter is required");
            }
            ArrayList<byte[]> userCertificates = (ArrayList<byte[]>)params.get("userCertificates");
            if (userCertificates != null) {
                if (userCertificates.size() != 1 && userCertificates.size() != 2) {
                    throw new IllegalArgumentException("Size of userCertificates must be from 1 to 2");
                }
            } else {
                byte[] userExchCertificate = (byte[])params.get("userExchCertificate");
                byte[] userSignCertificate = (byte[])params.get("userSignCertificate");
                if (userExchCertificate == null && userSignCertificate == null) {
                    throw new IllegalArgumentException("Parameter userExchCertificate or userSignCertificate is required");
                }
                userCertificates = new ArrayList<byte[]>();
                if (userExchCertificate != null) {
                    userCertificates.add(userExchCertificate);
                }
                if (userSignCertificate != null) {
                    userCertificates.add(userSignCertificate);
                }
            }
            byte[] dateInBytes = null;
            try {
                String stringDate = DateUtils.getInstance().dateToString(notAfter, "yyyyMMddHHmmss'Z'");
                dateInBytes = stringDate.getBytes("cp1251");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot format date to bytes");
            }
            this.handleKey1 = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)1);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)80, (byte[])UtilCM.intToByte((int)7, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            byte[] dateType = new byte[]{48, 17, -127, 15};
            byte[] newDate = new byte[19];
            System.arraycopy(dateType, 0, newDate, 0, 4);
            System.arraycopy(dateInBytes, 0, newDate, 4, 15);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)154, (byte[])newDate, (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)88, (byte[])UtilCM.addressToByte((Number)this.handleKey1, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            if (this.serverCertificate != null && this.serverCertificate.length > 0) {
                TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)89, (byte[])this.serverCertificate, (int)0);
            }
            for (int i = 0; i < userCertificates.size(); ++i) {
                Number hNewKey = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])((byte[])userCertificates.get(i)), (int)((byte[])userCertificates.get(i)).length, (Number)0, (int)0);
                TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)79, (byte[])UtilCM.addressToByte((Number)hNewKey, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
                hNewKeyList.add(i, hNewKey);
            }
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData((Number)this.handleProv, (Number)0, (Number)this.handleKey2, (int)57, (int)0);
            return byArray;
        }
        finally {
            if (hNewKeyList != null && hNewKeyList.size() > 0) {
                for (Number hNewKey : hNewKeyList) {
                    if (hNewKey.longValue() == 0L) continue;
                    TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)hNewKey);
                }
            }
        }
    }
}

