/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.profile.ProfileInfo;

public class OCSPRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createRequest(Map params) {
        Number handleProv = 0;
        Number handleExpKey = 0;
        Number handleKey = 0;
        try {
            String profile = (String)params.get("profile");
            if (profile == null || profile.trim().length() == 0) {
                throw new NullPointerException("parameter profile is required");
            }
            Integer keySpec = null;
            boolean profileChecking = ProfileParams.isProfile((String)profile);
            if (profileChecking) {
                keySpec = (Integer)params.get("keySpec");
                if (keySpec == null) {
                    keySpec = 2;
                }
                profile = ProfileParams.getProfileName((String)profile, (Boolean)true);
            }
            handleProv = TumarCspFunctions.cpAcquireContext((String)profile, (int)64, (Number)LibraryWrapper.PV_TABLE);
            if (!profileChecking) {
                ProfileInfo profileInfo = new ProfileInfo();
                String serialNumber = profileInfo.getDataFromUrl(profile, Integer.valueOf(1));
                try {
                    KeyParams keyParams = new KeyParams(handleProv);
                    Object[] algID = keyParams.getKeyAlgIDList();
                    CSPUtil cspUtil = new CSPUtil();
                    keySpec = cspUtil.getTypeKey(((Integer)algID[keyParams.getIndexSN(serialNumber)]).intValue());
                }
                catch (Exception e) {
                    throw new RuntimeCryptoException("Cannot obtain key usage for key with serial number: " + serialNumber);
                }
            }
            handleExpKey = TumarCspFunctions.cpGetUserKey((Number)handleProv, (int)keySpec);
            byte[] cert = TumarCspFunctions.cpGetKeyParamData((Number)handleProv, (Number)handleExpKey, (int)26, (int)0);
            handleKey = TumarCspFunctions.cpImportKey((Number)handleProv, (byte[])cert, (int)cert.length, (Number)0, (int)0);
            byte[] byArray = TumarCspFunctions.cpExportKeyData((Number)handleProv, (Number)handleKey, (Number)handleExpKey, (int)65, (int)0);
            return byArray;
        }
        finally {
            if (handleKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)handleProv, (Number)handleKey);
            }
            if (handleExpKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)handleProv, (Number)handleExpKey);
            }
            if (handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext((Number)handleProv, (int)0);
            }
        }
    }
}

