/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.cmp.CmpResponse;
import kz.gamma.core.UtilCM;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class PollingResponse
extends CmpResponse {
    private Integer checkAfter;
    private Date time;
    private int status;

    @Override
    protected boolean verify(Map params) {
        String userPassword;
        Boolean processResponse = (Boolean)params.get("processResponse");
        if (processResponse == null) {
            processResponse = false;
        }
        if ((userPassword = (String)params.get("userPassword")) != null && userPassword.trim().length() > 0) {
            this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)1);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)87, (byte[])DataConverter.stringToByteArray((String)userPassword), (int)0);
            TumarCspFunctions.cpVerifySignature((Number)this.handleProv, (Number)0, (byte[])this.response, (int)this.response.length, (Number)this.handleKey2, (String)"", (int)0x8000000);
        } else {
            byte[] serverCert = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)26, (int)0);
            this.handleKey2 = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])serverCert, (int)serverCert.length, (Number)0, (int)0);
            TumarCspFunctions.cpVerifySignature((Number)this.handleProv, (Number)0, (byte[])this.response, (int)this.response.length, (Number)this.handleKey2, (String)"", (int)0x8000000);
        }
        if (this.responseTypeCode == 1 || this.responseTypeCode == 3) {
            byte[] statusBytes = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)77, (int)0);
            this.status = UtilCM.byteToInt((byte[])statusBytes, (int)0, (int)1);
            if (this.status == 3) {
                try {
                    byte[] timeBytes = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)78, (int)0);
                    DateUtils dateUtils = DateUtils.getInstance();
                    this.time = dateUtils.stringToDate(new String(timeBytes));
                    System.out.println("time: " + this.time);
                }
                catch (Exception e) {
                    this.time = null;
                }
            } else {
                if (this.status == 2) {
                    return true;
                }
                if (processResponse.booleanValue() && (this.responseTypeCode == 1 || this.responseTypeCode == 3)) {
                    if (this.handleKey1.longValue() != 0L) {
                        TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)this.handleKey1);
                    }
                    this.handleKey1 = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)2);
                    TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)26, (byte[])this.response, (int)0);
                    TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)68, (byte[])this.response, (int)0);
                }
            }
        } else if (this.responseTypeCode == 26) {
            try {
                byte[] checkAfterByte = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)76, (int)0);
                this.checkAfter = UtilCM.byteToInt((byte[])checkAfterByte, (int)0, (int)1);
            }
            catch (Exception e) {
                this.checkAfter = null;
            }
        } else if (this.responseTypeCode != 22) {
            throw new RuntimeCryptoException("Unknown polling response type: " + this.responseTypeCode);
        }
        return true;
    }

    public Integer getCheckAfter() {
        return this.checkAfter;
    }

    private Date getTime() {
        return this.time;
    }

    public int getStatus() {
        return this.status;
    }

    public void setResponse(byte[] response) {
        this.response = response;
    }

    public List<byte[]> getCertificates() {
        ASN1InputStream in = null;
        ArrayList<byte[]> userCertificates = null;
        try {
            DERTaggedObject taggedObject1;
            userCertificates = new ArrayList<byte[]>();
            in = new ASN1InputStream(this.response);
            DERSequence asnBody = (DERSequence)in.readObject();
            DEREncodable element = asnBody.getObjectAt(1);
            if (element instanceof DERTaggedObject && ((taggedObject1 = (DERTaggedObject)element).getTagNo() == 1 || taggedObject1.getTagNo() == 3)) {
                DERSequence userCertificatesSequence = (DERSequence)((DERSequence)taggedObject1.getObject()).getObjectAt(1);
                Enumeration userCertificatesEnum = userCertificatesSequence.getObjects();
                while (userCertificatesEnum.hasMoreElements()) {
                    DERSequence object = (DERSequence)userCertificatesEnum.nextElement();
                    DERSequence cert = (DERSequence)((DERTaggedObject)((DERSequence)object.getObjectAt(2)).getObjectAt(0)).getObject();
                    userCertificates.add(cert.getDEREncoded());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Cannot get certificates from polling response");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return userCertificates;
    }
}

