/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.cmp.CmpRequest;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class SecretRequest
extends CmpRequest {
    public static final int ADD = 0;
    public static final int MOD = 1;
    public static final int GET = 2;
    public static final int DEL = 3;

    @Override
    protected byte[] create(Map params) {
        byte[] body = (byte[])params.get("body");
        if (body == null) {
            throw new NullPointerException("parameter body is required");
        }
        String secretOperationOid = (String)params.get("secretOperationOid");
        if (secretOperationOid == null || secretOperationOid.trim().length() == 0) {
            throw new NullPointerException("parameter secretOperationOid is required");
        }
        Integer operationType = (Integer)params.get("operationType");
        if (operationType == null) {
            throw new IllegalArgumentException("Operation type must not be null");
        }
        switch (operationType) {
            case 0: {
                return this.addSecretRequest(body, secretOperationOid);
            }
            case 1: {
                return this.modSecretRequest(body, secretOperationOid);
            }
            case 2: {
                if (secretOperationOid.equals("1.3.6.1.5.5.7.4.12")) {
                    throw new IllegalArgumentException("User cannot get own secret");
                }
                return this.getSecretRequest(body, secretOperationOid);
            }
            case 3: {
                if (secretOperationOid.equals("1.3.6.1.5.5.7.4.12")) {
                    return this.delSecretRequestUser(body, secretOperationOid);
                }
                return this.delSecretRequestAdmin(body, secretOperationOid);
            }
        }
        throw new IllegalArgumentException("Unknown operation type: " + operationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] addSecretRequest(byte[] body, String secretOperationOid) {
        Number handleKey3 = 0;
        try {
            this.handleKey1 = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)90, (byte[])secretOperationOid.getBytes(), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)88, (byte[])UtilCM.addressToByte((Number)this.handleKey1, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            if (this.serverCertificate == null || this.serverCertificate.length <= 0) {
                throw new NullPointerException("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
            }
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)89, (byte[])this.serverCertificate, (int)0);
            handleKey3 = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])this.serverCertificate, (int)this.serverCertificate.length, (Number)0, (int)0);
            byte[] algId = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)handleKey3, (int)7, (int)0);
            int algIdInt = UtilCM.byteToInt((byte[])algId, (int)0, (int)1);
            algIdInt = (algIdInt & 0x1FF) >= 80 ? 26115 : 26144;
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)this.handleKey1);
            }
            this.handleKey1 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)algIdInt, (int)1);
            int dw = 1;
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)4, (byte[])UtilCM.intToByte((int)dw, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            dw = 1;
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)3, (byte[])UtilCM.intToByte((int)dw, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            byte[] encryptedData = TumarCspFunctions.cpEncrypt((Number)this.handleProv, (Number)this.handleKey1, (Number)0, (int)1, (int)0, (byte[])body, (int)body.length, (int)body.length);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)110, (byte[])UtilCM.intToByte((int)encryptedData.length, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)111, (byte[])encryptedData, (int)0);
            int sz = TumarCspFunctions.cpExportKeySize((Number)this.handleProv, (Number)this.handleKey1, (Number)handleKey3, (int)80, (int)0x2000000);
            byte[] data = TumarCspFunctions.cpExportKeyDataEx((Number)this.handleProv, (Number)this.handleKey1, (Number)0, (int)80, (int)0x2000000, (int)sz);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)91, (byte[])data, (int)0);
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData((Number)this.handleProv, (Number)this.handleKey1, (Number)this.handleKey2, (int)57, (int)0);
            return byArray;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)handleKey3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] modSecretRequest(byte[] body, String secretOperationOid) {
        Number handleKey3 = 0;
        try {
            this.handleKey1 = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)90, (byte[])secretOperationOid.getBytes(), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)88, (byte[])UtilCM.addressToByte((Number)this.handleKey1, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            if (this.serverCertificate == null || this.serverCertificate.length <= 0) {
                throw new NullPointerException("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
            }
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)89, (byte[])this.serverCertificate, (int)0);
            handleKey3 = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])this.serverCertificate, (int)this.serverCertificate.length, (Number)0, (int)0);
            byte[] algId = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)handleKey3, (int)7, (int)0);
            int algIdInt = UtilCM.byteToInt((byte[])algId, (int)0, (int)1);
            algIdInt = (algIdInt & 0x1FF) >= 80 ? 26115 : 26144;
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)this.handleKey1);
            }
            this.handleKey1 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)algIdInt, (int)1);
            int dw = 1;
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)4, (byte[])UtilCM.intToByte((int)dw, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            dw = 1;
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)3, (byte[])UtilCM.intToByte((int)dw, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            byte[] encryptedData = TumarCspFunctions.cpEncrypt((Number)this.handleProv, (Number)this.handleKey1, (Number)0, (int)1, (int)0, (byte[])body, (int)body.length, (int)body.length);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)110, (byte[])UtilCM.intToByte((int)encryptedData.length, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)111, (byte[])encryptedData, (int)0);
            int sz = TumarCspFunctions.cpExportKeySize((Number)this.handleProv, (Number)this.handleKey1, (Number)handleKey3, (int)80, (int)0x2000000);
            byte[] data = TumarCspFunctions.cpExportKeyDataEx((Number)this.handleProv, (Number)this.handleKey1, (Number)0, (int)80, (int)0x2000000, (int)sz);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)91, (byte[])data, (int)0);
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData((Number)this.handleProv, (Number)this.handleKey1, (Number)this.handleKey2, (int)57, (int)0);
            return byArray;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)handleKey3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSecretRequest(byte[] body, String secretOperationOid) {
        Number handleKey3 = 0;
        try {
            this.handleKey1 = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)90, (byte[])secretOperationOid.getBytes(), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)88, (byte[])UtilCM.addressToByte((Number)this.handleKey1, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)91, (byte[])body, (int)0);
            if (this.serverCertificate != null && this.serverCertificate.length > 0) {
                TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)89, (byte[])this.serverCertificate, (int)0);
            }
            handleKey3 = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)1);
            byte[] clientExchCert = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)handleKey3, (int)26, (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)26, (byte[])clientExchCert, (int)0);
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData((Number)this.handleProv, (Number)this.handleKey1, (Number)this.handleKey2, (int)57, (int)0);
            return byArray;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)handleKey3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] delSecretRequestUser(byte[] body, String secretOperationOid) {
        Number handleKey3 = 0;
        try {
            this.handleKey1 = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)this.profileKeySpec);
            this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)90, (byte[])secretOperationOid.getBytes(), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)88, (byte[])UtilCM.addressToByte((Number)this.handleKey1, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            if (this.serverCertificate == null || this.serverCertificate.length <= 0) {
                throw new NullPointerException("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
            }
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)89, (byte[])this.serverCertificate, (int)0);
            handleKey3 = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])this.serverCertificate, (int)this.serverCertificate.length, (Number)0, (int)0);
            byte[] algId = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)handleKey3, (int)7, (int)0);
            int algIdInt = UtilCM.byteToInt((byte[])algId, (int)0, (int)1);
            algIdInt = (algIdInt & 0x1FF) >= 80 ? 26115 : 26144;
            if (this.handleKey1.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)this.handleKey1);
            }
            this.handleKey1 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)algIdInt, (int)1);
            int dw = 1;
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)4, (byte[])UtilCM.intToByte((int)dw, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            dw = 1;
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)3, (byte[])UtilCM.intToByte((int)dw, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            byte[] encryptedData = TumarCspFunctions.cpEncrypt((Number)this.handleProv, (Number)this.handleKey1, (Number)0, (int)1, (int)0, (byte[])body, (int)body.length, (int)body.length);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)110, (byte[])UtilCM.intToByte((int)encryptedData.length, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)111, (byte[])encryptedData, (int)0);
            int sz = TumarCspFunctions.cpExportKeySize((Number)this.handleProv, (Number)this.handleKey1, (Number)handleKey3, (int)80, (int)0x2000000);
            byte[] data = TumarCspFunctions.cpExportKeyDataEx((Number)this.handleProv, (Number)this.handleKey1, (Number)0, (int)80, (int)0x2000000, (int)sz);
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)91, (byte[])data, (int)0);
            byte[] byArray = this.request = TumarCspFunctions.cpExportKeyData((Number)this.handleProv, (Number)this.handleKey1, (Number)this.handleKey2, (int)57, (int)0);
            return byArray;
        }
        finally {
            if (handleKey3.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)handleKey3);
            }
        }
    }

    private byte[] delSecretRequestAdmin(byte[] body, String secretOperationOid) {
        this.handleKey1 = TumarCspFunctions.cpGetUserKey((Number)this.handleProv, (int)this.profileKeySpec);
        this.handleKey2 = TumarCspFunctions.cpGenKey((Number)this.handleProv, (int)41050, (int)0);
        TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)90, (byte[])secretOperationOid.getBytes(), (int)0);
        TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)88, (byte[])UtilCM.addressToByte((Number)this.handleKey1, (int)LibraryWrapper.SUN_CPU_ENDIAN), (int)0);
        TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)91, (byte[])body, (int)0);
        if (this.serverCertificate != null && this.serverCertificate.length > 0) {
            TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey2, (int)89, (byte[])this.serverCertificate, (int)0);
        }
        this.request = TumarCspFunctions.cpExportKeyData((Number)this.handleProv, (Number)this.handleKey1, (Number)this.handleKey2, (int)57, (int)0);
        return this.request;
    }
}

