/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.util.Map;
import kz.gamma.cmp.CmpResponse;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class SecretResponse
extends CmpResponse {
    @Override
    protected boolean verify(Map params) {
        if (this.responseTypeCode != 22) {
            throw new RuntimeCryptoException("Unknown secret response type: " + this.responseTypeCode);
        }
        String secretOperationOid = (String)params.get("secretOperationOid");
        Integer operationType = (Integer)params.get("operationType");
        if (operationType == null) {
            throw new IllegalArgumentException("Operation type must not be null");
        }
        switch (operationType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                if (secretOperationOid == null || secretOperationOid.trim().length() == 0) {
                    throw new NullPointerException("parameter secretOperationOid is required");
                }
                TumarCspFunctions.cpSetKeyParam((Number)this.handleProv, (Number)this.handleKey1, (int)90, (byte[])secretOperationOid.getBytes(), (int)0);
                this.usefulData = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)91, (int)0);
                if (this.handleKey1.longValue() != 0L) {
                    TumarCspFunctions.cpDestroyKey((Number)this.handleProv, (Number)this.handleKey1);
                }
                this.handleKey1 = TumarCspFunctions.cpImportKey((Number)this.handleProv, (byte[])this.usefulData, (int)this.usefulData.length, (Number)0, (int)0);
                byte[] pkcs7len = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)110, (int)0);
                int pkcs7lenInt = UtilCM.byteToInt((byte[])pkcs7len, (int)0, (int)1);
                if (pkcs7lenInt == 0) {
                    throw new RuntimeCryptoException("CMP_GENERAL_GET_USER_DETAILS. EnvelopedData size is 0");
                }
                byte[] pkcs7 = TumarCspFunctions.cpGetKeyParamData((Number)this.handleProv, (Number)this.handleKey1, (int)111, (int)0);
                this.usefulData = TumarCspFunctions.cpDecrypt((Number)this.handleProv, (Number)this.handleKey1, (Number)0, (int)1, (int)0, (byte[])pkcs7, (int)pkcs7lenInt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type: " + operationType);
            }
        }
        return true;
    }
}

