/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cmp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERBoolean;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.DERUTF8String;

public class UserSecretInfo {
    public static final int ADD = 0;
    public static final int MOD = 1;
    public static final int GET = 2;
    public static final int DEL = 3;

    public byte[] createAddBody(Map params) throws UnsupportedEncodingException {
        String country;
        String state;
        String city;
        String organization;
        String commonName;
        StringBuilder dn = new StringBuilder();
        String mail = (String)params.get("mail");
        if (mail != null && mail.trim().length() > 0) {
            dn.append("E=").append(mail).append(";");
        }
        if ((commonName = (String)params.get("commonName")) == null || commonName.trim().length() == 0) {
            throw new NullPointerException("commonName is required");
        }
        dn.append("CN=").append(commonName).append(";");
        String organizationalUnit = (String)params.get("organizationalUnit");
        if (organizationalUnit != null && organizationalUnit.trim().length() > 0) {
            dn.append("OU=").append(organizationalUnit).append(";");
        }
        if ((organization = (String)params.get("organization")) != null && organization.trim().length() > 0) {
            dn.append("O=").append(organization).append(";");
        }
        if ((city = (String)params.get("city")) != null && city.trim().length() > 0) {
            dn.append("L=").append(city).append(";");
        }
        if ((state = (String)params.get("state")) != null && state.trim().length() > 0) {
            dn.append("ST=").append(state).append(";");
        }
        if ((country = (String)params.get("country")) != null && country.trim().length() > 0) {
            dn.append("C=").append(country).append(";");
        }
        params.put("userName", dn.toString());
        String userPassword = (String)params.get("userPassword");
        if (userPassword == null || userPassword.trim().length() == 0) {
            throw new NullPointerException("parameter userPassword is required");
        }
        return this.createAsn(params, 0);
    }

    public byte[] createModBody(Map params) throws UnsupportedEncodingException {
        return this.createAsn(params, 1);
    }

    public byte[] createGetBody(Map params) throws UnsupportedEncodingException {
        return this.createAsn(params, 2);
    }

    public byte[] createDelBody(Map params) throws UnsupportedEncodingException {
        return this.createAsn(params, 3);
    }

    private byte[] createAsn(Map params, int type) throws UnsupportedEncodingException {
        String trustName;
        String displayName;
        Boolean userState;
        ASN1EncodableVector rootVector = new ASN1EncodableVector();
        String uid = (String)params.get("uid");
        if (uid != null && uid.trim().length() > 0) {
            rootVector.add((DEREncodable)new DEROctetString(uid.getBytes()));
        } else {
            rootVector.add((DEREncodable)new DEROctetString("".getBytes()));
        }
        String userName = (String)params.get("userName");
        if (userName != null && userName.trim().length() > 0) {
            rootVector.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)new DEROctetString(userName.getBytes("cp1251"))));
        } else if (type != 3) {
            throw new NullPointerException("parameter userName is required");
        }
        String userPassword = (String)params.get("userPassword");
        if (userPassword != null && userPassword.trim().length() > 0) {
            rootVector.add((DEREncodable)new DERTaggedObject(false, 2, (DEREncodable)new DEROctetString(userPassword.getBytes())));
        }
        if ((userState = (Boolean)params.get("userState")) != null) {
            rootVector.add((DEREncodable)new DERTaggedObject(false, 4, (DEREncodable)new DERBoolean(userState.booleanValue())));
        }
        if ((displayName = (String)params.get("displayName")) != null && displayName.trim().length() > 0) {
            rootVector.add((DEREncodable)new DERTaggedObject(false, 5, (DEREncodable)new DEROctetString(displayName.getBytes("cp1251"))));
        }
        if ((trustName = (String)params.get("trustName")) != null && trustName.trim().length() > 0) {
            rootVector.add((DEREncodable)new DERTaggedObject(false, 6, (DEREncodable)new DEROctetString(trustName.getBytes())));
        }
        return new DERSequence((DEREncodableVector)rootVector).getDEREncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map parseBody(byte[] body) throws IOException {
        ASN1InputStream in = null;
        boolean contextRead = false;
        try {
            in = new ASN1InputStream(body);
            DERSequence asnBody = (DERSequence)in.readObject();
            Enumeration data = asnBody.getObjects();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            while (data.hasMoreElements()) {
                Object element = data.nextElement();
                if (element instanceof DEROctetString) {
                    DEROctetString uid = (DEROctetString)element;
                    resultMap.put("uid", new String(uid.getOctets()));
                    continue;
                }
                if (!(element instanceof DERTaggedObject)) continue;
                DERTaggedObject taggedObject = (DERTaggedObject)element;
                if (taggedObject.getTagNo() == 1) {
                    if (taggedObject.getObject() instanceof DERNull || contextRead) continue;
                    DERUTF8String userName = DERUTF8String.getInstance((Object)taggedObject);
                    resultMap.put("userName", userName.getString());
                    contextRead = true;
                    continue;
                }
                if (taggedObject.getTagNo() == 2) {
                    DEROctetString userPassword = (DEROctetString)DEROctetString.getInstance((Object)taggedObject);
                    resultMap.put("userPassword", new String(userPassword.getOctets()));
                    continue;
                }
                if (taggedObject.getTagNo() == 4) {
                    DERBoolean userState = DERBoolean.getInstance((Object)taggedObject);
                    resultMap.put("userState", userState.isTrue());
                    continue;
                }
                if (taggedObject.getTagNo() == 5) {
                    DERUTF8String displayName = DERUTF8String.getInstance((Object)taggedObject);
                    resultMap.put("displayName", displayName.getString());
                    continue;
                }
                if (taggedObject.getTagNo() != 6) continue;
                DERUTF8String trustName = DERUTF8String.getInstance((Object)taggedObject);
                resultMap.put("trustName", trustName.getString());
            }
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

