#!/bin/sh
#Copyright © 1998-2024. Scientific Lab. Gamma Technologies. All rights reserved.

agentPath=$2/Library/LaunchAgents/crypto_socket.job.plist
app_ver='1.3(59)'
echo "TUMAR-CSP $app_ver action $1"

case "$1" in
install)
#--------------------------------------------------------------------------------------------------------------------------------------------------------
echo "kill TUMAR_CSP process"
killall TUMAR_CSP
echo "kill CryptoSocket process"
killall CryptoSocket

mkdir -p                                         /Library/LaunchAgents
rm -rf                                           /Library/TumarCSP
rsync -a "$3TumarCSP"                            /Library/

if [ -e /Library/LaunchAgents/tumar.environment.plist ]
    then
        rm                                       /Library/LaunchAgents/tumar.environment.plist
fi
if [ -e /Library/LaunchAgents/tumar.job.plist ]
    then
        rm                                       /Library/LaunchAgents/tumar.job.plist
fi


echo "remove old TUMAR_CSP"
if [ -e /Applications/TUMAR_CSP.app ]
 then
   rm -rf /Applications/TUMAR_CSP.app
fi
#cp -R /Library/TumarCSP/app/TUMAR_CSP.app                      /Applications/

echo "remove old CryptoSocket"
if [ -e /Applications/CryptoSocket.app ]
 then
   rm -rf /Applications/CryptoSocket.app
fi
#cp -R /Library/TumarCSP/app/CryptoSocket.app                   /Applications/
#rm -rf /Library/TumarCSP/app

ln -s /Library/TumarCSP/app/CryptoSocket.app /Applications/CryptoSocket.app
ln -s /Library/TumarCSP/app/TUMAR_CSP.app /Applications/TUMAR_CSP.app

TUMARCP_LIB=libcertex-csp.5.3.0.0.dylib
TUMARCP_LIB_R=libcertex-csp_r.5.3.0.0.dylib

#RESULT=$(echo $USER)
#echo "RESULT=$RESULT"

if [ -e /Library/TumarCSP/lib/$TUMARCP_LIB ]
    then
        ln -sf /Library/TumarCSP/lib/$TUMARCP_LIB        /Library/TumarCSP/lib/libcptumar.4.0.dylib
fi
if [ -e /Library/TumarCSP/lib/$TUMARCP_LIB_R ]
    then
        ln -sf /Library/TumarCSP/lib/$TUMARCP_LIB_R     /Library/TumarCSP/lib/libcptumar_r.4.0.dylib
fi
if [ -e /Library/TumarCSP/lib_arm64/$TUMARCP_LIB ]
    then
        ln -sf /Library/TumarCSP/lib_arm64/$TUMARCP_LIB        /Library/TumarCSP/lib_arm64/libcptumar.4.0.dylib
fi
if [ -e /Library/TumarCSP/lib_arm64/$TUMARCP_LIB_R ]
    then
        ln -sf /Library/TumarCSP/lib_arm64/$TUMARCP_LIB_R     /Library/TumarCSP/lib_arm64/libcptumar_r.4.0.dylib
fi

chmod ugo+r /Library/TumarCSP/etc/lic/*
chmod ugo+r /Library/TumarCSP/etc/lic_r/*
chmod ugo+r /Library/TumarCSP/etc/*
chmod ugo+r /Library/TumarCSP/cryptosocket/doc/*
chmod ugo+r /Library/TumarCSP/cryptosocket/conf/*
chmod ugo+r /Library/TumarCSP/cryptosocket/conf/media/img/*
chmod ugo+r /Library/TumarCSP/cryptosocket/conf/static/css/*
chmod ugo+r /Library/TumarCSP/cryptosocket/conf/static/js/*
chmod ugo+r /Library/TumarCSP/cryptosocket/conf/static/media/*
chmod ugo+r /Library/TumarCSP/cryptosocket/conf/static/css/*
chmod ugo+r /Library/TumarCSP/etc_arm64/lic/*
chmod ugo+r /Library/TumarCSP/etc_arm64/lic_r/*
chmod ugo+r /Library/TumarCSP/etc_arm64/*
chmod ugo+r /Library/TumarCSP/cryptosocket/key.dat

if ! [ -e /Library/TumarCSP/etc/cptumar.conf ]
    then
    echo "Create default conf" >>/tmp/tumarcsp_install.log
    touch /Library/TumarCSP/etc/cptumar.conf
    echo "[profiles]" >> /Library/TumarCSP/etc/cptumar.conf
    echo "FSystem=file://keys@/" >> /Library/TumarCSP/etc/cptumar.conf
    ls -la /Library/TumarCSP/etc/cptumar.conf >>/tmp/tumarcsp_install.log
    chmod 777 /Library/TumarCSP/etc
    chmod 777 /Library/TumarCSP/etc/cptumar.conf
fi

echo "Install trusted CA Certificate" >> /tmp/tumarcsp_install.log
ls -la /Library/TumarCPS/cert/ >> /tmp/tumarcsp_install.log

sudo security add-trusted-cert -d -r trustRoot -k "$HOME/Library/Keychains/login.keychain" /Library/TumarCSP/cert/root_rsa.crt >> /tmp/tumarcsp_install.log
sudo security add-trusted-cert -d -r trustRoot -k "$HOME/Library/Keychains/login.keychain" /Library/TumarCSP/cert/nca_rsa.crt >> /tmp/tumarcsp_install.log
sudo security add-trusted-cert -d -r trustRoot -k "$HOME/Library/Keychains/login.keychain" /Library/TumarCSP/cert/certs.pem >> /tmp/tumarcsp_install.log

cp /Library/TumarCSP/cert/root_rsa.crt "$HOME/Desktop/root_rsa.crt" >> /tmp/tumarcsp_install.log
cp /Library/TumarCSP/cert/nca_rsa.crt "$HOME/Desktop/nca_rsa.crt" >> /tmp/tumarcsp_install.log
cp /Library/TumarCSP/cert/127.0.0.1.cer "$HOME/Desktop/127.0.0.1.cer" >> /tmp/tumarcsp_install.log

# copy certs to $HOME/Desktop


if [ -e $agentPath ]
 then
 rm $agentPath
fi

touch  /Library/LaunchAgents/tumar.environment.plist
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"                                                                           >> /Library/LaunchAgents/tumar.environment.plist
echo "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">"           >> /Library/LaunchAgents/tumar.environment.plist
echo "<plist ersion=\"1.0\">"                                                                                               >> /Library/LaunchAgents/tumar.environment.plist
echo "<dict>"                                                                                                               >> /Library/LaunchAgents/tumar.environment.plist
echo "  <key>Label</key>"                                                                                                   >> /Library/LaunchAgents/tumar.environment.plist
echo "  <string>my.startup</string>"                                                                                        >> /Library/LaunchAgents/tumar.environment.plist
echo "  <key>ProgramArguments</key>"                                                                                        >> /Library/LaunchAgents/tumar.environment.plist
echo "  <array>"                                                                                                            >> /Library/LaunchAgents/tumar.environment.plist
echo "     <string>sh</string>"                                                                                             >> /Library/LaunchAgents/tumar.environment.plist
echo "     <string>-c</string>"                                                                                             >> /Library/LaunchAgents/tumar.environment.plist
echo "     <string>"                                                                                                        >> /Library/LaunchAgents/tumar.environment.plist
echo "     launchctl setenv CSP_PATH_HOME /Library/TumarCSP"                                                                >> /Library/LaunchAgents/tumar.environment.plist
echo "     </string>"                                                                                                       >> /Library/LaunchAgents/tumar.environment.plist
echo "            "                                                                                                         >> /Library/LaunchAgents/tumar.environment.plist
echo "  </array>"                                                                                                           >> /Library/LaunchAgents/tumar.environment.plist
echo "  <key>RunAtLoad</key>"                                                                                               >> /Library/LaunchAgents/tumar.environment.plist
echo "  <true/>"                                                                                                            >> /Library/LaunchAgents/tumar.environment.plist
echo "</dict>"                                                                                                              >> /Library/LaunchAgents/tumar.environment.plist
echo "</plist>"                                                                                                             >> /Library/LaunchAgents/tumar.environment.plist
mkdir -p             /Library/LaunchAgents
touch                /Library/LaunchAgents/tumar.job.plist
chmod 644            /Library/LaunchAgents/tumar.job.plist
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"                                                                           >> /Library/LaunchAgents/tumar.job.plist
echo "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">"           >> /Library/LaunchAgents/tumar.job.plist
echo "<plist version=\"1.0\">"                                                                                              >> /Library/LaunchAgents/tumar.job.plist
echo "<dict>"                                                                                                               >> /Library/LaunchAgents/tumar.job.plist
echo "  <key>KeepAlive</key>"                                                                                               >> /Library/LaunchAgents/tumar.job.plist
echo "    <dict>"                                                                                                           >> /Library/LaunchAgents/tumar.job.plist
echo "        <key>Crashed</key>"                                                                                           >> /Library/LaunchAgents/tumar.job.plist
echo "        <true/>"                                                                                                      >> /Library/LaunchAgents/tumar.job.plist
echo "        <key>SuccessfulExit</key>"                                                                                    >> /Library/LaunchAgents/tumar.job.plist
echo "        <false/>"                                                                                                     >> /Library/LaunchAgents/tumar.job.plist
echo "    </dict>"                                                                                                          >> /Library/LaunchAgents/tumar.job.plist
echo "    <key>Label</key>"                                                                                                 >> /Library/LaunchAgents/tumar.job.plist
echo "    <string>tumarcspagent.job</string>"                                                                               >> /Library/LaunchAgents/tumar.job.plist
echo "    <key>Program</key>"                                                                                               >> /Library/LaunchAgents/tumar.job.plist
echo "    <string>/Library/TumarCSP/bin/TumarAgent</string>"                                                                >> /Library/LaunchAgents/tumar.job.plist
echo "    <key>RunAtLoad</key>"                                                                                             >> /Library/LaunchAgents/tumar.job.plist
echo "    <true/>"                                                                                                          >> /Library/LaunchAgents/tumar.job.plist
echo "    <key>StandardErrorPath</key>"                                                                                     >> /Library/LaunchAgents/tumar.job.plist
echo "    <string>/tmp/tumarcspagent.job.stderr</string>"                                                                   >> /Library/LaunchAgents/tumar.job.plist
echo "    <key>StandardOutPath</key>"                                                                                       >> /Library/LaunchAgents/tumar.job.plist
echo "    <string>/tmp/tumarcspagent.job.stdout</string>"                                                                   >> /Library/LaunchAgents/tumar.job.plist
echo "</dict>"                                                                                                              >> /Library/LaunchAgents/tumar.job.plist
echo "</plist>"                                                                                                             >> /Library/LaunchAgents/tumar.job.plist
launchctl unload /Library/LaunchAgents/tumar.job.plist
launchctl load  /Library/LaunchAgents/tumar.job.plist
echo "TumarCSP $app_ver is successfully installed..."

touch $agentPath
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"                                                                           >> $agentPath
echo "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">"           >> $agentPath
echo "<plist ersion=\"1.0\">"                                                                                               >> $agentPath
echo "<dict>"                                                                                                               >> $agentPath
echo "  <key>Label</key>"                                                                                                   >> $agentPath
echo "  <string>kz.gt.cryptosocket</string>"                                                                                >> $agentPath
echo "  <key>ProgramArguments</key>"                                                                                        >> $agentPath

echo "  <array>"                                                                                                            >> $agentPath
echo "   <string>/Applications/CryptoSocket.app/Contents/MacOS/CryptoSocket</string>"                                       >> $agentPath
echo "   <string>-RunAsAgent</string>"                                                                                      >> $agentPath
echo "   <string>YES</string>"                                                                                              >> $agentPath
echo "  </array>"                                                                                                           >> $agentPath
echo "  <key>WorkingDirectory</key>"                                                                                        >> $agentPath
echo "  <string>/Applications/CryptoSocket.app/Contents/</string>"                                                          >> $agentPath
echo "  <key>Disabled</key>"                                                                                                >> $agentPath
echo "  <false/>"                                                                                                           >> $agentPath

echo "  <key>RunAtLoad</key>"                                                                                               >> $agentPath
echo "  <true/>"                                                                                                            >> $agentPath
echo "  <key>KeepAlive</key>"                                                                                               >> $agentPath
echo "  <false/>"                                                                                                           >> $agentPath

echo "</dict>"                                                                                                              >> $agentPath
echo "</plist>"                                                                                                             >> $agentPath


echo "Install KAZTOKEN driver" >> /tmp/tumarcsp_install.log
open /Library/TumarCSP/bin/KaztokenInstaller.pkg

echo "Script install done" >> /tmp/tumarcsp_install.log
echo "CryptoSocket is successfully installed..."
;;

############  OLD SCRIPT ###############################################################################################################################

update)
###########################################################################################################################################
killall CryptoSocketService
killall CryptoSocket
killall TUMAR_CSP

rm -rf                                           /Applications/TUMAR_CSP.app
rm -rf                                           /Library/TumarCSP
rm -rf                                           /Library/CryptoSocket

rsync -a "$3TumarCSP"                            /Library/
rsync -a "$3CryptoSocket"                        /Library/

tar -xvf /Library/TumarCSP/lib/lib.tar -C /Library/TumarCSP/lib/
#tar -xvf /Library/CryptoSocket/cs.tar  -C        /Library/CryptoSocket/

rm /Library/TumarCSP/lib/lib.tar
#rm                                               /Library/CryptoSocket/cs.tar

cp -R "$3TUMAR_CSP.app"                              /Applications/

ln -sf /Library/TumarCSP/lib/libcertex-csp.4.2.0.0.dylib        /Library/TumarCSP/lib/libcptumar.4.0.dylib
ln -sf /Library/TumarCSP/lib/libcertex-csp_r.4.2.0.0.dylib      /Library/TumarCSP/lib/libcptumar_r.4.0.dylib
chmod 755                                        /Library/TumarCSP/etc/lic/*
chmod 755                                        /Library/TumarCSP/etc/lic_r/*
chmod 755                                        /Library/TumarCSP/etc/*


rm -rf /Applications/CryptoSocket.app
cp -R "$3CryptoSocket.app" /Applications/
launchctl unload /Library/LaunchAgents/tumar.job.plist
launchctl load  /Library/LaunchAgents/tumar.job.plist
echo "CryptoSocket is successfully updated to version $app_ver."

cp -R "$3local-settings.js"                  /Applications/Firefox.app/Contents/Resources/defaults/pref/

#cp -R "$3mozilla.txt"                  /tmp/
#mv /tmp/mozilla.txt /tmp/mozilla.tar.gz
#tar -xvf /tmp/mozilla.tar.gz -C /tmp/
#cd /tmp/Mozilla
#sudo ./import_cert.sh


cp -R "$3KaztokenInstaller.txt"                  /tmp/
mv /tmp/KaztokenInstaller.txt /tmp/KaztokenInstaller.pkg
open /tmp/KaztokenInstaller.pkg


#    killall CryptoSocket
#    rm -rf /Applications/CryptoSocket.app
#    cp -R "$3CryptoSocket.app" /Applications/
#    echo "CryptoSocket is successfully updated to version $app_ver."
;;

uninstall)
###########################################################################################################################################
killall TUMAR_CSP >> /tmp/tumarcsp_install.log
killall CryptoSocket >> /tmp/tumarcsp_install.log
killall CryptoSocketService >> /tmp/tumarcsp_install.log
rm -rf                                           /Applications/TUMAR_CSP.app
rm -rf                                           /Library/TumarCSP
rm -rf                                           /Library/CryptoSocket
rm                                               /Library/LaunchAgents/tumar.environment.plist
rm                                               /Library/LaunchAgents/tumar.job.plist
rm -rf /Applications/CryptoSocket.app
if [ -e $agentPath ]
 then
 rm $agentPath
fi
#sudo security remove-trusted-cert -d "$3CryptoSocketKey.crt"

echo "Script uninstall run" >> /tmp/tumarcsp_install.log

if [ -e /Library/TumarCSP/etc/lic ]
    then
        rm /Library/TumarCSP/etc/lic/*
fi
if [ -e /Library/TumarCSP/etc/lic_r ]
    then
        rm /Library/TumarCSP/etc/lic_r/*
fi
if [ -e /Library/TumarCSP/lib ]
    then
        rm /Library/TumarCSP/lib/*
fi
if [ -e /Library/TumarCSP/etc ]
    then
        rm /Library/TumarCSP/etc/*.reg
fi
if [ -e /Library/TumarCSP/CryptoSocket ]
    then
        rm -R /Library/TumarCSP/CryptoSocket
fi


if [ -e /Applications/TUMAR_CSP.app ]
    then
        rm -R /Applications/TUMAR_CSP.app >> /tmp/tumarcsp_install.log
fi


if [ -e /Applications/CryptoSocket.app ]
    then
        rm -R /Applications/CryptoSocket.app >> /tmp/tumarcsp_install.log
fi


if [ -e /Library/CryptoSocket ]
    then
        rm -R /Library/CryptoSocket >> /tmp/tumarcsp_install.log
fi


echo "Script uninstall stop" >> /tmp/tumarcsp_install.log

echo "CryptoSocket is successfully uninstalled..."
;;
*)
echo "    "
exit 0
esac
